//-----------------------------------------------------------------------------------------
// File : ShadowVS.hlsl
// Desc : Generate Shadow Map. 
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float3  Position    : POSITION;         //!< ʒuWł([JWn).
    float3  Normal      : NORMAL;           //!< @xNgł([JWn).
    float3  Tangent     : TANGENT;          //!< ڃxNgł([JWn).
    float2  TexCoord    : TEXCOORD;         //!< eNX`Wł.
};

///////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4  Position : SV_POSITION;         //!< ʒuWł(r[ˉe).
};

///////////////////////////////////////////////////////////////////////////////////////////
// CBMatrix buffer
///////////////////////////////////////////////////////////////////////////////////////////
cbuffer CBMatrix : register( b1 )
{
    float4x4    World       : packoffset( c0 );     //!< [hsł.
    float4x4    ViewProj    : packoffset( c4 );     //!< r[ˉesł.
};


//-----------------------------------------------------------------------------------------
//! @brief      _VF[_CGg[|Cgł.
//-----------------------------------------------------------------------------------------
VSOutput VSFunc( VSInput input )
{
    VSOutput output = (VSOutput)0;

    float4 localPos    = float4( input.Position, 1.0f );
    float4 worldPos    = mul( World,    localPos );
    float4 viewProjPos = mul( ViewProj, worldPos );

    output.Position = viewProjPos;

    return output;
}

/* ̒_VF[_ɑΉsNZVF[_͂܂.*/
