//-----------------------------------------------------------------------------------------
// File : ForwardVS.hlsl
// Desc : Forward Shading [Vertex Shader]
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float3  Position    : POSITION;         //!< ʒuWł([JWn).
    float3  Normal      : NORMAL;           //!< @xNgł([JWn).
    float3  Tangent     : TANGENT;          //!< ڃxNgł([JWn).
    float2  TexCoord    : TEXCOORD;         //!< eNX`Wł.
};

///////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4  Position    : SV_POSITION;          //!<@r[ˉeԂ̈ʒuWł.
    float4  WorldPos    : WORLD_POSITION;       //!< [hԂ̈ʒuWł.
    float3  Normal      : NORMAL;               //!< @xNgł.
    float2  TexCoord    : TEXCOORD0;            //!< eNX`Wł.
    float3  LightDir    : LIGHT_DIRECTION;      //!< Cg̕xNgł.
    float3  CameraPos   : CAMERA_POSITION;      //!< Jʒuł.
    float4  SplitPos    : SPLIT_POSITION;       //!< ł.
    float4  SdwCoord[4] : SHADOW_COORD;         //!< VhEWł.
};

///////////////////////////////////////////////////////////////////////////////////////////
// CBMatrix buffer
///////////////////////////////////////////////////////////////////////////////////////////
cbuffer CBMatrix : register( b1 )
{
    float4x4 World                  : packoffset( c0 );     //!< [hsł.
    float4x4 View                   : packoffset( c4 );     //!< r[sł.
    float4x4 Proj                   : packoffset( c8 );     //!< ˉesł.
    float4   CameraPos              : packoffset( c12 );    //!< Jʒuł.
    float4   LightDir               : packoffset( c13 );    //!< Cgʒuł.
    float4   SplitPos               : packoffset( c14 );    //!< ł.
    float4x4 Shadow0                : packoffset( c15 );    //!< VhE}bvs0.
    float4x4 Shadow1                : packoffset( c19 );    //!< VhE}bvs1.
    float4x4 Shadow2                : packoffset( c23 );    //!< VhE}bvs2.
    float4x4 Shadow3                : packoffset( c27 );    //!< VhE}bvs3.
};


//-----------------------------------------------------------------------------------------
//! @brief      _VF[_CGg[|Cg.
//-----------------------------------------------------------------------------------------
VSOutput VSFunc( VSInput input )
{
    VSOutput output = (VSOutput)0;

    float4 localPos = float4( input.Position, 1.0f );
    float4 worldPos = mul( World, localPos );
    float4 viewPos  = mul( View,  worldPos );
    float4 projPos  = mul( Proj,  viewPos );

    output.Position = projPos;
    output.WorldPos = worldPos;
    output.LightDir = -LightDir.xyz;

    output.Normal   = input.Normal;
    output.TexCoord = input.TexCoord;

    output.CameraPos = CameraPos.xyz;

    // JXP[hVhE}bvp.
    output.SplitPos    = SplitPos;
    output.SdwCoord[0] = mul( Shadow0, worldPos );
    output.SdwCoord[1] = mul( Shadow1, worldPos );
    output.SdwCoord[2] = mul( Shadow2, worldPos );
    output.SdwCoord[3] = mul( Shadow3, worldPos );

    return output;
}