//-----------------------------------------------------------------------------------------
// File : ShadowPS.hlsl
// Desc : Debug Pixel Shader For Shadow Map.
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------------


///////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4  Position : SV_POSITION;
    float4  ProjPos : PROJ_POS;
};

///////////////////////////////////////////////////////////////////////////////////////////
// PSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4 Color : SV_TARGET0;
};

//-----------------------------------------------------------------------------------------
//      CGg[|Cgł.
//------------------------------------------------------------------------------------------
PSOutput PSFunc( VSOutput input )
{
    PSOutput output = (PSOutput)0;

    float z = input.ProjPos.z / input.ProjPos.w;
    float3 baseColor = float3( z, z, z );

    output.Color = float4( z, z, 1.0, 1.0f );

    return output;
}