//------------------------------------------------------------------------------------------
// File : QuadRenderer.fx
// Desc : Quad Renderer Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------


////////////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
////////////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float3 Position : POSITION;     //!< ʒuWł.
    float2 TexCoord : TEXCOORD;     //!< eNX`Wł.
};

////////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
////////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4 Position : SV_POSITION;  //!< ʒuWł.
    float2 TexCoord : TEXCOORD0;    //!< eNX`Wł.
};

////////////////////////////////////////////////////////////////////////////////////////////
// PSOutput structure
////////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4 Color0 : SV_TARGET0;     //!< o̓J[ł.
};

////////////////////////////////////////////////////////////////////////////////////////////
// TransformParam Buffer
////////////////////////////////////////////////////////////////////////////////////////////
cbuffer TransformParam : register( b0 )
{
    float4x4 ScaleOffset : packoffset( c0 );      //!< XP[ItZbgsł.
};

////////////////////////////////////////////////////////////////////////////////////////////
// Textures and Samplers
////////////////////////////////////////////////////////////////////////////////////////////
Texture2D               DecalMap : register( t0 );      //!< fJ[eNX`ł.
SamplerState            DecalSmp : register( s0 );      //!< fJ[eNX`̃Tv[ł.


//------------------------------------------------------------------------------------------
//! @brief      _VF[_̃CGg[|Cgł.
//------------------------------------------------------------------------------------------
VSOutput VSFunc( VSInput input )
{
    VSOutput output = (VSOutput)0;

    float4 localPos = float4( input.Position, 1.0f );
    float4 pos = mul( ScaleOffset, localPos );      // XP[ϊ + sړ.

    output.Position = pos;
    output.TexCoord = input.TexCoord;

    return output;
}

//------------------------------------------------------------------------------------------
//! @brief      sNZVF[_̃CGg[|Cgł.
//------------------------------------------------------------------------------------------
PSOutput PSFunc( VSOutput input )
{
    PSOutput output = (PSOutput)0;

    output.Color0.rgb = DecalMap.Sample( DecalSmp, input.TexCoord ).xxx;
    output.Color0.a = 1.0f;

    return output;
}

