//-----------------------------------------------------------------------------------------
// File : ForwardPS.hlsl
// Desc : Forward Shading.
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------------


// ~ł.
#define PI          3.1415926535f

///////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4  Position : SV_POSITION;
    float4  WorldPos : WORLD_POSITION;
    float3  Normal   : NORMAL;
    float2  TexCoord : TEXCOORD0;
    float3  LightDir : LIGHT_DIRECTION;
    float3  ViewDir  : VIEW_DIRECTION;
    float4  SdwCoord : SHADOW_COORD;
};


///////////////////////////////////////////////////////////////////////////////////////////
// PSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4 Color : SV_TARGET0;
};


/////////////////////////////////////////////////////////////////////////////////////////
// Material Buffer
/////////////////////////////////////////////////////////////////////////////////////////
cbuffer Material : register( b0 )
{
    float3 Diffuse  : packoffset( c0 );     //!< gUːFł.
    float  Alpha    : packoffset( c0.w );   //!< ߓxł.
    float3 Specular : packoffset( c1 );     //!< ʔːFł.
    float  Power    : packoffset( c1.w );   //!< ʔˋxł.
    float3 Emissive : packoffset( c2 );     //!< ȏƖFł.
    float  Bump     : packoffset( c2.w );   //!< ov}bsOtO.
};


//---------------------------------------------------------------------------------------
// Textures
//---------------------------------------------------------------------------------------
Texture2D       DiffuseMap    : register( t0 );     //!< fBt[Y}bvł.
Texture2D       SpecularMap   : register( t1 );     //!< XyL[}bvł.
Texture2D       BumpMap       : register( t2 );     //!< ov}bvł.
Texture2D       ShadowMap     : register( t3 );     //!< VhE}bvł.


//---------------------------------------------------------------------------------------
// Samplers
//---------------------------------------------------------------------------------------
SamplerState            DiffuseSmp    : register( s0 );     //!< fBt[Y}bvpTv[Xe[gł.
SamplerState            SpecularSmp   : register( s1 );     //!< XyL[}bvpTv[Xe[gł.
SamplerState            BumpSmp       : register( s2 );     //!< ov}bvpTv[Xe[gł.
SamplerComparisonState  ShadowSmp     : register( s3 );     //!< VhE}bvpTv[rXe[gł.


//-----------------------------------------------------------------------------------------------
//! @biref      Ko[gCeBOvZ܂.
//!
//! @param [in]     diffuse     gUːF.
//! @param [in]     lightDir    CgxNg.
//! @param [in]     normal      @xNg.
//! @return     o[gCeBOʂԋp܂.
//-----------------------------------------------------------------------------------------------
float3 NormalizedLambert( float3 diffuse, float3 lightDir, float3 normal )
{
   return diffuse * max( dot( normal, lightDir ), 0.0f ) * ( 1.0f / PI );
}

//------------------------------------------------------------------------------------------------
//! @brief      KtHCeBOs܂.
//!
//! @param [in]     specular    ʔːF.
//! @param [in]     power       ʔˋx.
//! @param [in]     viewDir     xNg.
//! @param [in]     normal      @xNg.
//! @parma [in]     lightDir    CgxNg.
//! @return     tHCeBǑʂԋp܂.
//------------------------------------------------------------------------------------------------
float3 NormalizedPhong( float3 specular, float power, float3 viewDir, float3 normal, float3 lightDir )
{
    float3 R = -viewDir + ( 2.0f * dot( normal, viewDir ) * normal );

    return specular * pow( max ( dot( lightDir, R ), 0.0f ), power ) * ( ( power + 1.0f )/ ( 2.0 * PI ) );
}


//------------------------------------------------------------------------------------------------
//! @brief      sNZVF[_̃Gg[|Cgł.
//------------------------------------------------------------------------------------------------
PSOutput PSFunc( VSOutput input )
{
    PSOutput output = (PSOutput)0;

    // fBt[Y}bvtFb`.
    float4 mapKd = DiffuseMap.Sample( DiffuseSmp, input.TexCoord );

    // At@eXg.
    clip( ( mapKd.a < 0.125f ) ? -1.0f : 1.0f );

    // XyL[}bvtFb`.
    float4 mapKs = SpecularMap.Sample( SpecularSmp, input.TexCoord );

    // VhE}bv̐[xlƔr.
    float3 shadowCoord = input.SdwCoord.xyz / input.SdwCoord.w;

    // ő[xX΂߂.
    float  maxDepthSlope = max( abs( ddx( shadowCoord.z ) ), abs( ddy( shadowCoord.z ) ) );

    float  shadowThreshold = 1.0f;      // VhEɂ邩ǂ臒lł.
    float  bias            = 0.01f;     // ŒoCAXł.
    float  slopeScaledBias = 0.01f;     // [xX.
    float  depthBiasClamp  = 0.1f;      // oCAXNvl.

    float  shadowBias = bias + slopeScaledBias * maxDepthSlope;
    shadowBias = min( shadowBias, depthBiasClamp );

    float3 shadowColor     = float3( 0.25f, 0.25f, 0.25f );
    shadowThreshold = ShadowMap.SampleCmpLevelZero( ShadowSmp, shadowCoord.xy, shadowCoord.z - shadowBias );
    shadowColor     = lerp( shadowColor, float3( 1.0f, 1.0f, 1.0f ), shadowThreshold );

    // XyL[}bvtFb`.
    float4 spe = SpecularMap.Sample( SpecularSmp, input.TexCoord );
    {
        float3 N = normalize( input.Normal );
        float3 V = normalize( input.ViewDir );
        float3 L = normalize( input.LightDir );

        float3 diffuse   = NormalizedLambert( Diffuse * mapKd.rgb, L, N );
        float3 specular  = NormalizedPhong( Specular * mapKs.rgb, Power, V, N, L );
        output.Color.rgb = ( diffuse + specular ) * shadowColor;
        output.Color.a   = Alpha;
    }

    return output;
}