﻿//--------------------------------------------------------------------------------------------
// File : asdxDepthStencilTarget.h
// Desc : Depth Stencil Buffer Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_DEPTH_STENCIL_TARGET_H__
#define __ASDX_DEPTH_STENCIL_TARGET_H__

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------
#include <d3d11.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
// DepthStencilTarget class
//////////////////////////////////////////////////////////////////////////////////////////////
class DepthStencilTarget
{
public:
    //////////////////////////////////////////////////////////////////////////////////////////
    // Description structer
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Description
    {
        UINT                Width;
        UINT                Height;
        UINT                MipLevels;
        UINT                ArraySize;
        DXGI_FORMAT         Format;
        DXGI_SAMPLE_DESC    SampleDesc;
        UINT                CPUAccessFlags;
        UINT                MiscFlags;

        //------------------------------------------------------------------------------------
        //! @brief      コンストラクタです.
        //------------------------------------------------------------------------------------
        Description()
        : Width         ( 0 )
        , Height        ( 0 )
        , MipLevels     ( 0 )
        , ArraySize     ( 0 )
        , Format        ( DXGI_FORMAT_UNKNOWN )
        , CPUAccessFlags( 0 )
        , MiscFlags     ( 0 )
        {
            SampleDesc.Count   = 0;
            SampleDesc.Quality = 0;
        }
    };

    //=======================================================================================
    // public variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // public methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------
    DepthStencilTarget();

    //---------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------
    virtual ~DepthStencilTarget();

    //---------------------------------------------------------------------------------------
    //! @brief      深度ステンシルバッファを生成します.
    //!
    //! @param [in]     pDevice     デバイスです.
    //! @param [in]     desc        概要です.
    //! @retval true    深度ステンシルバッファの生成に成功.
    //! @retval false   深度ステンシルバッファの生成に失敗.
    //---------------------------------------------------------------------------------------
    bool Create( ID3D11Device* pDevice, const Description& desc );

    //---------------------------------------------------------------------------------------
    //! @brief      テクスチャを取得します.
    //!
    //! @retrun     テクスチャを返却します.
    //---------------------------------------------------------------------------------------
    ID3D11Texture2D* GetTexture() const;

    //---------------------------------------------------------------------------------------
    //! @brief      シェーダリソースビューを取得します.
    //!
    //! @return     シェーダリソースビューを返却します.
    //---------------------------------------------------------------------------------------
    ID3D11ShaderResourceView* GetSRV() const;

    //---------------------------------------------------------------------------------------
    //! @brief      深度ステンシルビューを取得します.
    //!
    //! @return     深度ステンシルビューを返却します.
    //---------------------------------------------------------------------------------------
    ID3D11DepthStencilView* GetDSV() const;

    //---------------------------------------------------------------------------------------
    //! @brief      解放処理を行います.
    //---------------------------------------------------------------------------------------
    void Release();

protected:
    //=======================================================================================
    // protected variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // protected methods
    //=======================================================================================
    /* NOTHING */

private:
    //=======================================================================================
    // private variables.
    //=======================================================================================
    ID3D11Texture2D*            m_pTexture;     //!< テクスチャです.
    ID3D11ShaderResourceView*   m_pSRV;         //!< シェーダリソースビューです.
    ID3D11DepthStencilView*     m_pDSV;         //!< 深度ステンシルビューです.

    //=======================================================================================
    // private methods.
    //=======================================================================================
    DepthStencilTarget( const DepthStencilTarget& );    // アクセス禁止.
    void operator =   ( const DepthStencilTarget& );    // アクセス禁止.
};

} // namespace asdx


#endif//__ASDX_DEPTH_STENCIL_TARGET_H__
