//------------------------------------------------------------------------------------------
// File : SimplePS.fx
// Desc : Simple Pixel Shader
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include "SimpleDecl.fxh"


//---------------------------------------------------------------------------------------
//! @brief      Ko[gCeBOs܂.
//!
//! @param [in]     diffuse     gUːF.
//! @param [in]     lightDir    CgxNg.
//! @param [in]     normal      @xNg.
//! @return     o[gCeBOʂԋp܂.
//---------------------------------------------------------------------------------------
float3 NormalizedLambert( float3 diffuse, float3 lightDir, float3 normal )
{
   return diffuse * max( dot( normal, lightDir ), 0.0f ) * ( 1.0f / PI );
}

//---------------------------------------------------------------------------------------
//! @brief      KtHCeBOs܂.
//!
//! @param [in]     specular    ʔːF.
//! @param [in]     power       ʔˋx.
//! @param [in]     viewDir     xNg.
//! @param [in]     normal      @xNg.
//! @parma [in]     lightDir    CgxNg.
//! @return     tHCeBǑʂԋp܂.
//---------------------------------------------------------------------------------------
float3 NormalizedPhong( float3 specular, float power, float3 viewDir, float3 normal, float3 lightDir )
{
    float3 R = -viewDir + ( 2.0f * dot( normal, viewDir ) * normal );

    return specular * pow( max ( dot( lightDir, R ), 0.0f ), power ) * ( ( power + 1.0f )/ ( 2.0 * PI ) );
}


//----------------------------------------------------------------------------------------
//! @brief      sNZVF[_̃CGg[|Cgł.
//!
//! @param [in]     input       _VF[_̏o͒lł.
//! @return     e_[^[Qbgւ̏o͒lԋp܂.
//----------------------------------------------------------------------------------------
PSOutput PSFunc( VSOutput input )
{
    // [NA.
    PSOutput output = (PSOutput)0;

    // fBt[YAxh}bvtFb`.
    float4 diffuseMapColor  = DiffuseMap.Sample( DiffuseSmp, input.TexCoord );

    // XyL[}bvtFb`.
    float4 specularMapColor = SpecularMap.Sample( SpecularSmp, input.TexCoord );

    // At@eXg.
    clip( ( diffuseMapColor.a < 0.125f ) ? -1.0f : 1.0f );

    // @xNgvZ.
    float3 N = normalize( input.Normal );

    // CgxNgvZ.
    float3 L = normalize( input.LightDir );

    // xNgvZ.
    float3 V = normalize( input.ViewDir );

    // fBt[YJ[vZ.
    float3 diffuse  = NormalizedLambert( Diffuse * diffuseMapColor.rgb, L, N );
    
    // XyL[J[vZ.
    //float3 specular = NormalizedPhong( Specular * specularMapColor.rgb, Power, V, N, L ); // ʏgp̎.
    float3 specular = NormalizedPhong( 0.8f, 50.0f, V, N, L ); // fɃXyL[Ȃ̂ŋIɂ. 

    // o͒lݒ.
    output.Color0.xyz = diffuse + specular;
    output.Color0.a   = Alpha;

    return output;

}