//--------------------------------------------------------------------------------------------
// File : asdMesh.h
// Desc : Asura Mesh Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_MESH_H__
#define __ASDX_MESH_H__

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------
#include <d3d11.h>
#include <asdxMath.h>
#include <asdxResMesh.h>
#include <asdxTexture.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
//  Mesh class
//////////////////////////////////////////////////////////////////////////////////////////////
class Mesh
{
    //========================================================================================
    // list of friend classes and methods.
    //========================================================================================
    /* NOTHING */

public:
    //////////////////////////////////////////////////////////////////////////////////////////
    // MaterialBuffer structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct MaterialBuffer
    {
        asdx::FLOAT3    Diffuse;        //!< gUːł.
        asdx::FLOAT     Alpha;          //!< ߓxł.
        asdx::FLOAT3    Specular;       //!< ʔːł.
        asdx::FLOAT     Power;          //!< ʔˋxł.

        MaterialBuffer()
        { /* DO_NOTHING */ }
    };

    //////////////////////////////////////////////////////////////////////////////////////////
    // TextureMap structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct TextureMap
    {
        asdx::Texture   Diffuse;        //!< fBt[Y}bvł.
        asdx::Texture   Specular;       //!< XyL[}bvł.
        asdx::Texture   Normal;         //!< @}bvł.

        TextureMap()
        : Diffuse ()
        , Specular()
        , Normal  ()
        { /* DO_NOTHING */ }
    };

    //////////////////////////////////////////////////////////////////////////////////////////
    // Material structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Material
    {
        MaterialBuffer  Buffer;         //!< }eAobt@ł.
        TextureMap      TextureMap;     //!< eNX`}bvł.

        Material()
        : Buffer    ()
        , TextureMap()
        { /* DO_NOTHING */ }
    };

    //////////////////////////////////////////////////////////////////////////////////////////
    // Subset structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Subset
    {
        asdx::UINT      IndexOffset;    //!< CfbNXItZbgł.
        asdx::UINT      IndexCount;     //!< CfbNXJEgł.
        asdx::UINT      MaterialID;     //!< }eAԍł.
    };

    //========================================================================================
    // public variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // public methods.
    //========================================================================================

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    Mesh();

    //----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------------
    virtual ~Mesh();

    //----------------------------------------------------------------------------------------
    //! @brief      ł.
    //----------------------------------------------------------------------------------------
    bool Init( 
        ID3D11Device*        pDevice,
        const asdx::ResMesh& mesh,
        const void*          pShaderBytecode,
        const asdx::UINT     byteCodeLength,
        const char*          resFolderPath = "../res/",
        const char*          dummyFolderPath = "../res/"
    );

    //----------------------------------------------------------------------------------------
    //! @brief      `揈ł.
    //----------------------------------------------------------------------------------------
    void Draw( ID3D11DeviceContext* pDeviceContext );

    //----------------------------------------------------------------------------------------
    //! @brief      Ił.
    //----------------------------------------------------------------------------------------
    void Term();

protected:
    //////////////////////////////////////////////////////////////////////////////////////////
    //  TEXTURE_SLOT enum
    //////////////////////////////////////////////////////////////////////////////////////////
    enum TEXTURE_SLOT
    {
        TEXTURE_SLOT_DIFFUSE  = 0,  //!< fBt[Y}bṽXbgԍł.
        TEXTURE_SLOT_SPECULAR,      //!< XyL[}bṽXbgԍł.
        TEXTURE_SLOT_NORMAL,        //!< @}bṽXbgԍł.
        MAX_TEXTURE_SLOT            //!< eNX`Xbgł.
    };

    //========================================================================================
    // protected variables.
    //========================================================================================
    ID3D11Buffer*       m_pVB;              //!< _obt@ł.
    ID3D11Buffer*       m_pIB;              //!< CfbNXobt@ł.
    ID3D11Buffer*       m_pMB;              //!< }eAobt@ł.
    ID3D11InputLayout*  m_pIL;              //!< ̓CAEgł.
    ID3D11SamplerState* m_pDiffuseSmp;      //!< fBt[Y}bṽTv[Xe[gł.
    ID3D11SamplerState* m_pSpecularSmp;     //!< XyL[}bṽTv[Xe[gł.
    ID3D11SamplerState* m_pNormalSmp;       //!< @}bṽTv[Xe[gł.
    asdx::UINT          m_Stride;           //!< XgChł.
    asdx::UINT          m_Offset;           //!< ItZbgł.
    asdx::UINT          m_SubsetCount;      //!< TuZbgł.
    asdx::UINT          m_MaterialCount;    //!< }eAł.
    Mesh::Subset*       m_pSubset;          //!< TuZbgł.
    Mesh::Material*     m_pMaterial;        //!< }eAł.

    //========================================================================================
    // protected methods
    //========================================================================================

    //----------------------------------------------------------------------------------------
    //! @brief      ̓CAEg̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     shaderByteCode      VF[_̃oCgR[hł.
    //! @param [in]     byteCodeLength      oCgR[h̒ł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateIL( ID3D11Device* pDevice, const void* shaderByteCode, const asdx::UINT byteCodeLength );

    //----------------------------------------------------------------------------------------
    //! @brief      _obt@̏ł.
    //!
    //! @parma [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateVB( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      CfbNXobt@̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateIB( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      }eAobt@̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateMB( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      Tv[Xe[g̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateSmp( ID3D11Device* pDevice );

    //----------------------------------------------------------------------------------------
    //! @brief      TuZbg̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateSubset( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      }eȀł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @param [in]     resPath             eNX`t@Ci[Ă郊\[XtH_pXł.
    //! @param [in]     dummyPath           _~[eNX`i[ĂtH_pXł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    virtual bool    OnCreateMaterial( ID3D11Device* pDevice, const asdx::ResMesh& mesh, const char* resPath, const char* dummyPath );

    //----------------------------------------------------------------------------------------
    //! @brief      `Jn̏ł.
    //!
    //! @param [in]     pDeviceContext      foCXReLXgł.
    //----------------------------------------------------------------------------------------
    virtual void    OnDrawBegin( ID3D11DeviceContext* pDeviceContext );

    //----------------------------------------------------------------------------------------
    //! @brief      TuZbg`掞̏ł.
    //!
    //! @param [in]     pDeviceContext      foCXReLXgł.
    //! @param [in]     index               TuZbgCfbNXł.
    //----------------------------------------------------------------------------------------
    virtual void    OnDrawSubset( ID3D11DeviceContext* pDeviceContext, const asdx::UINT index );

    //----------------------------------------------------------------------------------------
    //! @brief      `Ȉł.
    //----------------------------------------------------------------------------------------
    virtual void    OnDrawEnd( ID3D11DeviceContext* pDeviceContext );

    //----------------------------------------------------------------------------------------
    //! @brief      }eȀł.
    //----------------------------------------------------------------------------------------
    virtual void    OnTermMaterial();

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̓̓CAEg̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     shaderByteCode      VF[_̃oCgR[hł.
    //! @param [in]     byteCodeLength      oCgR[h̒ł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool    DefOnCreateIL( ID3D11Device* pDevice, const void* shaderByteCode, const asdx::UINT byteCodeLength );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̒_obt@̏ł.
    //!
    //! @parma [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool    DefOnCreateVB( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃CfbNXobt@̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
     bool    DefOnCreateIB( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃}eAobt@̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool    DefOnCreateMB( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃Tv[Xe[g̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool    DefOnCreateSmp( ID3D11Device* pDevice );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃TuZbg̏ł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool    DefOnCreateSubset( ID3D11Device* pDevice, const asdx::ResMesh& mesh );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃}eȀł.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     mesh                bVł.
    //! @param [in]     resPath             eNX`t@Ci[Ă郊\[XtH_pXł.
    //! @param [in]     dummyPath           _~[eNX`i[ĂtH_pXł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool    DefOnCreateMaterial( ID3D11Device* pDevice, const asdx::ResMesh& mesh, const char* resPath, const char* dummyPath );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̕`Jn̏ł.
    //!
    //! @param [in]     pDeviceContext      foCXReLXgł.
    //----------------------------------------------------------------------------------------
    void    DefOnDrawBegin( ID3D11DeviceContext* pDeviceContext );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃TuZbg`掞̏ł.
    //!
    //! @param [in]     pDeviceContext      foCXReLXgł.
    //! @param [in]     index               TuZbgCfbNXł.
    //----------------------------------------------------------------------------------------
    void    DefOnDrawSubset( ID3D11DeviceContext* pDeviceContext, const asdx::UINT index );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̕`Ȉł.
    //----------------------------------------------------------------------------------------
    void    DefOnDrawEnd( ID3D11DeviceContext* pDeviceContext );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg̃}eȀł.
    //----------------------------------------------------------------------------------------
    void    DefOnTermMaterial();

private:
    //========================================================================================
    // private variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // private methods.
    //========================================================================================
    Mesh            ( const Mesh& value );      // ANZX֎~.
    void operator = ( const Mesh& value );      // ANZX֎~.

};


} // namespace asdx

#endif//__ASDX_MESH_H__
