//---------------------------------------------------------------------------------------
// File : SampleApp.cpp
// Desc : Sample Application
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------
#include "SampleApp.h"
#include <asdxLog.h>
#include <asdxShader.h>
#include <asdxTimer.h>



/////////////////////////////////////////////////////////////////////////////////////////
// SampleApplication class
/////////////////////////////////////////////////////////////////////////////////////////

//---------------------------------------------------------------------------------------
//      RXgN^ł.
//---------------------------------------------------------------------------------------
SampleApplication::SampleApplication()
: Application   ( "Normalized Lambert" )
, m_Font         ()
, m_pTB         ( nullptr )
, m_pVS         ( nullptr )
, m_pPS         ( nullptr )
, m_Dosei       ()
, m_Ground      ()
{ /* DO_NOTHING */ }

//---------------------------------------------------------------------------------------
//      fXgN^ł.
//---------------------------------------------------------------------------------------
SampleApplication::~SampleApplication()
{ /* DO_NOTHING */ }

//---------------------------------------------------------------------------------------
//      ̏ł.
//---------------------------------------------------------------------------------------
bool SampleApplication::OnInit()
{
    if ( !m_Font.Init( m_pDevice, "../res/font/SetoMini-P.fnt", (float)m_Width, (float)m_Height ) )
    {
        ELOG( "Error : asdx::Font::Init() Failed." );
        return false;
    }

    HRESULT hr = S_OK;
    {
        ID3DBlob* pVSBlob = nullptr;

        // _VF[_RpC.
        hr = asdx::ShaderHelper::CompileShaderFromFile( 
            L"../res/SimpleVS.fx",
            "VSFunc",
            asdx::ShaderHelper::VS_4_0,
            &pVSBlob
        );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : CompileShaderFromFile() Failed." );
            return false;
        }

        // _VF[_𐶐.
        hr = m_pDevice->CreateVertexShader( pVSBlob->GetBufferPointer(), pVSBlob->GetBufferSize(), nullptr, &m_pVS );
        if ( FAILED( hr ) )
        {
            pVSBlob->Release();
            pVSBlob = nullptr;

            ELOG( "Error : ID3D11Device::CreateVertexShader() Failed." );
            return false;
        }

        // ǂ̏.
        {
            // \[XbV[h܂.
            asdx::ResMesh resMesh;
            if ( !resMesh.LoadFromFile( "../res/dosei/dosei.msh" ) )
            {
                ELOG( "Error : Mesh Load Failed." );
                return false;
            }

            // `惁bV̏.
            if ( !m_Dosei.Init( m_pDevice, resMesh, pVSBlob->GetBufferPointer(), pVSBlob->GetBufferSize(), "../res/dosei/", "../res/dummy/" ) )
            {
                ELOG( "Error : TinyMesh::Init() Failed." );
                return false;
            }

            // \[XbV.
            resMesh.Release();
        }

        // nʂ̏.
        {
            // \[XbV[h܂.
            asdx::ResMesh resMesh;
            if ( !resMesh.LoadFromFile( "../res/ground/ground.msh" ) )
            {
                ELOG( "Error : Mesh Load Failed." );
                return false;
            }

            // `惁bV̏.
            if ( !m_Ground.Init( m_pDevice, resMesh, pVSBlob->GetBufferPointer(), pVSBlob->GetBufferSize(), "../res/ground/", "../res/dummy/" ) )
            {
                ELOG( "Error : TinyMesh::Init() Failed." );
                return false;
            }

            // \[XbV.
            resMesh.Release();
        }

        // VF[_R[h.
        pVSBlob->Release();
        pVSBlob = nullptr;
    }

    if ( !m_AxisRenderer.Init( m_pDevice ) )
    {
        ELOG( "Error : AxisRenderer::Init() Failed." );
        return false;
    }

    {
        ID3DBlob* pPSBlob = nullptr;

        // sNZVF[_RpC.
        hr = asdx::ShaderHelper::CompileShaderFromFile(
            L"../res/SimplePS.fx",
            "PSFunc",
            asdx::ShaderHelper::PS_4_0,
            &pPSBlob 
        );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : CompileShaderFromFile() Failed." );
            return false;
        }

        // sNZVF[_𐶐.
        hr = m_pDevice->CreatePixelShader(
            pPSBlob->GetBufferPointer(),
            pPSBlob->GetBufferSize(),
            nullptr,
            &m_pPS
        );

        pPSBlob->Release();
        pPSBlob = nullptr;

        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11CreatePixelShader() Failed." );
            return false;
        }
    }

    {
        // ϊp[^obt@̐ݒ.
        D3D11_BUFFER_DESC bd;
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        bd.Usage          = D3D11_USAGE_DEFAULT;
        bd.ByteWidth      = sizeof( TransformParam );
        bd.BindFlags      = D3D11_BIND_CONSTANT_BUFFER;
        bd.CPUAccessFlags = 0;

        // ϊp[^obt@𐶐.
        hr = m_pDevice->CreateBuffer( &bd, nullptr, &m_pTB );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11Device::CreateBuffer() Failed." );
            return false;
        }

        // AXyNgZo.
        float aspectRatio = (float)m_Width/(float)m_Height;

        // J̐ݒ.
        m_Camera.GetCamera().SetPosition( asdx::FLOAT3( -100.0f, 0.0f, 0.0f ) );
        m_Camera.GetCamera().SetTarget( asdx::FLOAT3( 0.0f, 0.0f, 0.0f ) );
        m_Camera.GetCamera().SetUpward( asdx::FLOAT3( 0.0f, 1.0f, 0.0f ) );
        m_Camera.GetCamera().Preset();
        m_Camera.GetCamera().Update();

        // ϊp[^ݒ.
        m_TransformParam.Light = asdx::FLOAT4( -100.0f, 100.0f, 0.0f, 1.0f );
        m_TransformParam.Proj  = asdx::CreatePerspectiveFieldOfView( asdx::F_PIDIV4, aspectRatio, 0.1f, 100000.0f );
        m_TransformParam.View  = m_Camera.GetView();
        m_TransformParam.World.Identity();
    }

    return true;
}

//---------------------------------------------------------------------------------------
//      Ȉł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnTerm()
{
    // tHg̏I.
    m_Font.Term();

    // _VF[_.
    if ( m_pVS )
    {
        m_pVS->Release();
        m_pVS = nullptr;
    }

    // sNZVF[_.
    if ( m_pPS )
    {
        m_pPS->Release();
        m_pPS = nullptr;
    }

    // f̏I.
    m_Dosei.Term();
    m_Ground.Term();

    // _[̏I
    m_AxisRenderer.Term();

    // ϊp[^obt@.
    if ( m_pTB )
    {
        m_pTB->Release();
        m_pTB = nullptr;
    }
}

//---------------------------------------------------------------------------------------
//      t[Jڎ̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnFrameMove( double time, double elapsedTime )
{
    // r[sXV.
    m_TransformParam.View = m_Camera.GetView();
}

//---------------------------------------------------------------------------------------
//      eLXg`掞̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnDrawText()
{
    m_Font.Begin( m_pDeviceContext );
    {
        m_Font.DrawStringArg( 10, 10, "FPS : %.2f", GetFPS() );
    }
    m_Font.End( m_pDeviceContext );
}

//---------------------------------------------------------------------------------------
//      bV`掞̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnDrawMesh()
{
    // VF[_̐ݒ.
    m_pDeviceContext->VSSetShader( m_pVS,   nullptr, 0 );
    m_pDeviceContext->GSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->HSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->DSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->PSSetShader( m_pPS,   nullptr, 0 );

    // ϊp[^obt@XV.
    m_TransformParam.World = asdx::CreateScale( 0.25f );
    m_pDeviceContext->UpdateSubresource( m_pTB, 0, nullptr, &m_TransformParam, 0, 0 );

    // _VF[_ɒ萔obt@ݒ.
    m_pDeviceContext->VSSetConstantBuffers( 1, 1, &m_pTB );

    // ǂ`.
    m_Dosei.Draw( m_pDeviceContext );

    // ϊp[^obt@XV.
    m_TransformParam.World = asdx::CreateTranslation( 0.0f, -10.0f, 0.0f );
    m_pDeviceContext->UpdateSubresource( m_pTB, 0, nullptr, &m_TransformParam, 0, 0 );

    // _VF[_ɒ萔obt@ݒ.
    m_pDeviceContext->VSSetConstantBuffers( 1, 1, &m_pTB );

    // nʂ`.
    m_Ground.Draw( m_pDeviceContext );

    // J̒_`.
    m_AxisRenderer.Begin( m_pDeviceContext, m_Camera.GetView(), m_TransformParam.Proj );
    m_AxisRenderer.Render( m_pDeviceContext, m_Camera.GetCamera().GetTarget() );
    m_AxisRenderer.End( m_pDeviceContext );
}

//---------------------------------------------------------------------------------------
//      `掞̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnFrameRender( double time, double elapsedTime )
{
    // _[^[Qbgr[E[xXeVr[擾.
    ID3D11RenderTargetView* pRTV = m_RenderTarget2D.GetRTV();
    ID3D11DepthStencilView* pDSV = m_DepthStencilBuffer.GetDSV();

    // NULL`FbN.
    if ( pRTV == nullptr )
    { return; }
    if ( pDSV == nullptr )
    { return; }
    
    // o̓}l[Wɐݒ.
    m_pDeviceContext->OMSetRenderTargets( 1, &pRTV, pDSV );

    // NA.
    m_pDeviceContext->ClearRenderTargetView( pRTV, m_ClearColor );
    m_pDeviceContext->ClearDepthStencilView( pDSV, D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0f, 0 );

    // Xe[gݒ.
    m_pDeviceContext->RSSetState( m_pRasterizerState );
    m_pDeviceContext->OMSetBlendState( m_pBlendState, m_BlendFactor, m_SampleMask );
    m_pDeviceContext->OMSetDepthStencilState( m_pDepthStencilState, m_StencilRef );

    // `揈.
    {
        // bV`.
        OnDrawMesh();

        // eLXg`.
        OnDrawText();
    }

    // R}hsāCʂɕ\.
    m_pSwapChain->Present( 0, 0 );
}

//---------------------------------------------------------------------------------------
//      TCYCxg̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnResize( const asdx::ResizeEventParam& param )
{
    // ˉesXV.
    m_TransformParam.Proj = asdx::CreatePerspectiveFieldOfView( asdx::F_PIDIV4, param.AspectRatio, 0.1f, 1000.0f );
}

//---------------------------------------------------------------------------------------
//      L[Cxg̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnKey( const asdx::KeyEventParam& param )
{
    // J.
    m_Camera.OnKey( param.KeyCode, param.IsKeyDown, param.IsAltDown );
}

//---------------------------------------------------------------------------------------
//      }EXCxg̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnMouse( const asdx::MouseEventParam& param )
{
    // J.
    m_Camera.OnMouse( 
        param.X,
        param.Y,
        param.WheelDelta,
        param.IsLeftButtonDown,
        param.IsRightButtonDown,
        param.IsMiddleButtonDown,
        param.IsSideButton1Down,
        param.IsSideButton2Down
    );
}
