//------------------------------------------------------------------------------------------
// File : SimplePS.fx
// Desc : Simple Pixel Shader
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include "SimpleDecl.fxh"


//---------------------------------------------------------------------------------------
//! @brief      Ko[gCeBOs܂.
//!
//! @param [in]     diffuse     gUːF.
//! @param [in]     lightDir    CgxNg.
//! @param [in]     normal      @xNg.
//! @return     o[gCeBOʂԋp܂.
//---------------------------------------------------------------------------------------
float3 NormalizedLambert( float3 diffuse, float3 lightDir, float3 normal )
{
   return diffuse * max( dot( normal, lightDir ), 0.0f ) * ( 1.0f / PI );
}


//----------------------------------------------------------------------------------------
//! @brief      sNZVF[_̃CGg[|Cgł.
//!
//! @param [in]     input       _VF[_̏o͒lł.
//! @return     e_[^[Qbgւ̏o͒lԋp܂.
//----------------------------------------------------------------------------------------
PSOutput PSFunc( VSOutput input )
{
    // [NA.
    PSOutput output = (PSOutput)0;

    // fBt[YAxh}bvtFb`.
    float4 diffuseMapColor  = DiffuseMap.Sample( DiffuseSmp, input.TexCoord );

    // At@eXg.
    clip( ( diffuseMapColor.a < 0.125f ) ? -1.0f : 1.0f );

    // @xNgvZ.
    float3 N = normalize( input.Normal );

    // CgxNgvZ.
    float3 L = normalize( input.LightDir );

    // fBt[YJ[vZ.
    float3 diffuse  = NormalizedLambert( Diffuse * diffuseMapColor.rgb, L, N );

    // o͒lݒ.
    output.Color0.xyz = diffuse;
    output.Color0.a   = Alpha;

    return output;

}