//---------------------------------------------------------------------------------------------
// File : asdxTextRenderer.h
// Desc : Text Renderer Module.
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------------

#ifndef __ASDX_TEXT_RENDERER_H__
#define __ASDX_TEXT_RENDERER_H__

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <d3d11.h>
#include <asdxMath.h>
#include <vector>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////
// TextRenderer class
///////////////////////////////////////////////////////////////////////////////////////////////
class TextRenderer
{
    //========================================================================================
    // list of friend classes and methods.
    //========================================================================================
    /* NOTHING */

public:
    //////////////////////////////////////////////////////////////////////////////////////////
    // Glyph structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Glyph
    {
        uint32_t    Character;      //!< R[hł.
        RECT        SubRect;        //!< `ł.
        float       OffsetX;        //!< X̃ItZbgł.
        float       OffsetY;        //!< ỸItZbgł.
        float       AdvanceX;       //!< Xy[Xł.
    };

    //========================================================================================
    // public variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // public methods.
    //========================================================================================

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    TextRenderer();

    //----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------------
    virtual ~TextRenderer();

    //----------------------------------------------------------------------------------------
    //! @brief      ł.
    //!
    //! @param [in]     pDevice     foCXł.
    //! @param [in]     filename    tHgt@Cł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool Init( ID3D11Device* pDevice, const wchar_t* filename );

    //----------------------------------------------------------------------------------------
    //! @brief      Ił.
    //----------------------------------------------------------------------------------------
    void Term();

    //----------------------------------------------------------------------------------------
    //! @brief      `Jnł.
    //----------------------------------------------------------------------------------------
    void Begin();

    //----------------------------------------------------------------------------------------
    //! @brief      `悵܂.
    //!
    //! @param [in]     text            `悷镶ł.
    //! @param [in]     position        `Jnʒuł.
    //! @param [in]     color           J[ł.
    //! @param [in]     layDepth        C[̐[ł.
    //----------------------------------------------------------------------------------------
    void DrawString( wchar_t* text, FLOAT2 position, FLOAT4 color = FLOAT4( 1.0f, 1.0f, 1.0f, 1.0f ), float layerDepth = 0.0f );

    //----------------------------------------------------------------------------------------
    //! @brief      `Ił.
    //----------------------------------------------------------------------------------------
    void End( ID3D11DeviceContext* pDeviceContext );

    //----------------------------------------------------------------------------------------
    //! @brief      sԃTCY擾܂.
    //!
    //! @return     sԃTCYԋp܂.
    //----------------------------------------------------------------------------------------
    float   GetLineSpace() const;

    //----------------------------------------------------------------------------------------
    //! @brief      sԃTCYݒ肵܂.
    //!
    //! @param [in]     lineSpace       ݒ肷sԃTCYł.
    //----------------------------------------------------------------------------------------
    void    SetLineSpace( float lineSpace );

    //----------------------------------------------------------------------------------------
    //! @brief      ftHg擾܂.
    //!
    //! @return     ftHgԋp܂.
    //----------------------------------------------------------------------------------------
    wchar_t GetDefaultCharacter() const;

    //----------------------------------------------------------------------------------------
    //! @brief      ftHgݒ肵܂.
    //!
    //! @param [in]     character       ݒ肷ftHgł.
    //----------------------------------------------------------------------------------------
    void    SetDefaultCharacter( wchar_t character );

    //----------------------------------------------------------------------------------------
    //! @brief      w肳ꂽ܂܂Ă邩`FbN܂.
    //!
    //! @retval true    ܂܂Ă܂.
    //! @retval false   ܂܂Ă܂.
    //----------------------------------------------------------------------------------------
    bool    ContainsCharacter( wchar_t character ) const;


protected:
    //////////////////////////////////////////////////////////////////////////////////////////
    // Vertex structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Vertex
    {
        FLOAT3      Position;       //!< ʒuWł.
        FLOAT4      Color;          //!< _J[ł.
        FLOAT2      TexCoord;       //!< eNX`Wł.

        static const size_t                     InputElementCount = 3;                  //!< ͗vfł.
        static const D3D11_INPUT_ELEMENT_DESC   InputElements[ InputElementCount ];     //!< ͗vfł.
    };

    //========================================================================================
    // protected variables.
    //========================================================================================
    static const size_t     NUM_MAX_SPRITE        = 2048;       //!< őXvCgł.
    static const size_t     NUM_VERTEX_PER_SPRITE = 4;          //!< 1XvCg̒_ł.
    static const size_t     NUM_INDEX_PER_SRPITE  = 6;          //!< 1XvCg̃CfbNXł.

    ID3D11VertexShader*         m_pVS;              //!< _VF[_ł.
    ID3D11PixelShader*          m_pPS;              //!< sNZVF[_ł.
    ID3D11InputLayout*          m_pIL;              //!< ̓CAEgł.
    ID3D11Buffer*               m_pVB;              //!< _obt@ł.
    ID3D11Buffer*               m_pIB;              //!< CfbNXobt@ł.
    ID3D11Buffer*               m_pCB;              //!< 萔obt@ł.
    ID3D11Texture2D*            m_pTexture;         //!< eNX`ł.
    ID3D11ShaderResourceView*   m_pSRV;             //!< VF[_\[Xr[ł.
    ID3D11SamplerState*         m_pSmp;             //!< Tv[Xe[gł.
    std::vector<Glyph>          m_Glyphs;           //!< Otł.
    Glyph const*                m_pDefaultGlyph;    //!< ftHgOtł.
    float                       m_LineSpace;        //!< sԃTCYł.
    size_t                      m_SpriteCount;      //!< `悷XvCgł.
    bool                        m_IsBeginDraw;

    FLOAT2 MeasureString( wchar_t const* text ) const;
    Glyph const* FindGlyph   ( wchar_t character ) const;
    void         DrawSprite( 
        ID3D11ShaderResourceView* pSRV,
        FLOAT2 position,
        RECT const* pSrcRect,
        FLOAT4 color,
        FLOAT2 origin,
        float layerDepth
    );

private:
    //========================================================================================
    // private variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // private methods.
    //========================================================================================
    TextRenderer    ( const TextRenderer& value );      // ANZX֎~.
    void operator = ( const TextRenderer& value );      // ANZX֎~.
};

} // namespace asdx


#endif//__ASDX_TEXT_RENDERER_H__