//--------------------------------------------------------------------------------------------
// File : asdxMesh.h
// Desc : Resource Mesh Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_RES_MESH_H__
#define __ASDX_RES_MESH_H__

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------
#include <asdxMath.h>
#include <d3d11.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
// ResMesh class
//////////////////////////////////////////////////////////////////////////////////////////////
class ResMesh
{
    //========================================================================================
    // list of friend classes and methods.
    //========================================================================================
    /* NOTHING */

public:
    //========================================================================================
    // Type definition.
    //========================================================================================
    typedef asdx::UINT      Index;

    //========================================================================================
    // public variables.
    //========================================================================================
    static const asdx::UINT NUM_FILENAME        = 256;
    static const asdx::UINT NUM_INPUT_ELEMENT   = 4;
    static const D3D11_INPUT_ELEMENT_DESC INPUT_ELEMENTS[ NUM_INPUT_ELEMENT ];

    //////////////////////////////////////////////////////////////////////////////////////////
    // Vertex structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Vertex
    {
        asdx::FLOAT3    Position;   //!< ʒuWł.
        asdx::FLOAT3    Normal;     //!< @xNgł.
        asdx::FLOAT3    Tangent;    //!< ڃxNgł.
        asdx::FLOAT2    TexCoord;   //!< eNX`Wł.
    };

    //////////////////////////////////////////////////////////////////////////////////////////
    // Material structure
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Material
    {
        asdx::FLOAT3    Ambient;                            //!< Fł.
        asdx::FLOAT3    Diffuse;                            //!< gUːFł.
        asdx::FLOAT3    Specular;                           //!< ʔːFł.
        asdx::FLOAT3    Emissive;                           //!< ȏƖFł.
        asdx::FLOAT     Alpha;                              //!< ߓxł.
        asdx::FLOAT     Power;                              //!< ʔˋxł.
        char            AmbientMap     [ NUM_FILENAME ];    //!< ArGg}bvł.
        char            DiffuseMap     [ NUM_FILENAME ];    //!< fBt[Y}bvł.
        char            SpecularMap    [ NUM_FILENAME ];    //!< XyL[}bvł.
        char            BumpMap        [ NUM_FILENAME ];    //!< ʃ}bvł.
        char            DisplacementMap[ NUM_FILENAME ];    //!< ψʃ}bvł.
    };

    /////////////////////////////////////////////////////////////////////////////////////////
    // Subset structure
    /////////////////////////////////////////////////////////////////////////////////////////
    struct Subset
    {
        asdx::UINT      IndexOffset;        //!< CfbNobt@擪̃ItZbgł.
        asdx::UINT      IndexCount;         //!< `悷CfbNXł.
        asdx::UINT      MaterialID;         //!< }eAIDł.
    };


    //========================================================================================
    // public methods.
    //========================================================================================

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    ResMesh();

    //----------------------------------------------------------------------------------------
    //! @brief      Rs[RXgN^ł.
    //----------------------------------------------------------------------------------------
    ResMesh( const ResMesh& ResMesh );

    //----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------------
    virtual ~ResMesh();

    //----------------------------------------------------------------------------------------
    //! @brief      Zqł.
    //!
    //! @param [in]     ResMesh            lł.
    //! @return     ʂԋp܂.
    //----------------------------------------------------------------------------------------
    ResMesh& operator = ( const ResMesh& ResMesh );

    //----------------------------------------------------------------------------------------
    //! @brief      t@Cf[^[h܂.
    //!
    //! @param [in]     filename        ̓t@Cł.
    //! @retval true    [hɐ.
    //! @retval false   [hɎs.
    //----------------------------------------------------------------------------------------
    bool        LoadFromFile( const char* filename );

    //----------------------------------------------------------------------------------------
    //! @brief      ܂.
    //----------------------------------------------------------------------------------------
    void        Release();

    //----------------------------------------------------------------------------------------
    //! @brief      _擾܂.
    //!
    //! @return     _ԋp܂.
    //----------------------------------------------------------------------------------------
    asdx::UINT  GetVertexCount  () const;

    //----------------------------------------------------------------------------------------
    //! @brief      CfbNX擾܂.
    //!
    //! @return     CfbNXԋp܂.
    //----------------------------------------------------------------------------------------
    asdx::UINT  GetIndexCount   () const;

    //----------------------------------------------------------------------------------------
    //! @brief      }eA擾܂.
    //!
    //! @return     }eAԋp܂.
    //----------------------------------------------------------------------------------------
    asdx::UINT  GetMaterialCount() const;

    //----------------------------------------------------------------------------------------
    //! @brief      TuZbg擾܂.
    //!
    //! @return     TuZbgԋp܂.
    //----------------------------------------------------------------------------------------
    asdx::UINT  GetSubsetCount  () const;

    //----------------------------------------------------------------------------------------
    //! @brief      _f[^擾܂.
    //!
    //! @param [in]     idx     _ԍ.
    //! @return     w肳ꂽ_f[^ԋp܂.
    //----------------------------------------------------------------------------------------
    ResMesh::Vertex      GetVertex   ( const asdx::UINT idx ) const;

    //----------------------------------------------------------------------------------------
    //! @brief      CfbNXf[^擾܂.
    //! 
    //! @param [in]     idx     CfbNXԍ.
    //! @return     w肳ꂽCfbNXf[^ԋp܂.
    //----------------------------------------------------------------------------------------
    ResMesh::Index       GetIndex    ( const asdx::UINT idx ) const;

    //----------------------------------------------------------------------------------------
    //! @brief      }eAf[^擾܂.
    //!
    //! @param [in]     idx     }eAԍ.
    //! @return     w肳ꂽ}eAf[^ԋp܂.
    //----------------------------------------------------------------------------------------
    ResMesh::Material    GetMaterial  ( const asdx::UINT idx ) const;

    //----------------------------------------------------------------------------------------
    //! @brief      TuZbgf[^擾܂.
    //!
    //! @param [in]     idx     TuZbgԍ.
    //! @return     w肳ꂽTuZbgf[^ԋp܂.
    //----------------------------------------------------------------------------------------
    ResMesh::Subset      GetSubset   ( const asdx::UINT idx ) const;

    //----------------------------------------------------------------------------------------
    //! @brief      _f[^擾܂.
    //!
    //! @return     _f[^ԋp܂.
    //----------------------------------------------------------------------------------------
    const ResMesh::Vertex*     GetVertices () const;

    //----------------------------------------------------------------------------------------
    //! @brief      _CfbNXf[^擾܂.
    //!
    //! @return     _CfbNXf[^ԋp܂.
    //----------------------------------------------------------------------------------------
    const ResMesh::Index*      GetIndices  () const;

    //----------------------------------------------------------------------------------------
    //! @brief      }eAf[^擾܂.
    //!
    //! @return     }eAf[^ԋp܂.
    //----------------------------------------------------------------------------------------
    const ResMesh::Material*   GetMaterials () const;

    //----------------------------------------------------------------------------------------
    //! @brief      TuZbgf[^擾܂.
    //!
    //! @return     TuZbgf[^ԋp܂.
    //----------------------------------------------------------------------------------------
    const ResMesh::Subset*     GetSubsets  () const;

protected:
    //========================================================================================
    // protected variables.
    //========================================================================================
    asdx::UINT  m_VertexCount;      //!< _ł.
    asdx::UINT  m_IndexCount;       //!< _CfbNXł.
    asdx::UINT  m_MaterialCount;    //!< }eAł.
    asdx::UINT  m_SubsetCount;      //!< TuZbgł.

    ResMesh::Vertex*     m_pVertex;          //!< _f[^ł.
    ResMesh::Index*      m_pIndex;           //!< _CfbNXf[^ł.
    ResMesh::Material*   m_pMaterial;        //!< }eAf[^ł.
    ResMesh::Subset*     m_pSubset;          //!< TuZbgf[^ł.

    //========================================================================================
    // protected methods.
    //========================================================================================
    /* NOTHING */

private:
    //========================================================================================
    // private variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // private methods.
    //========================================================================================
    /* NOTHING */
};


} // namespace asdx


#endif//__ASDX_RES_MESH_H__
