//-----------------------------------------------------------------------------------------
// File : asdxTimer.h
// Desc : Timer Module.
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------------

#ifndef __ASDX_TIMER_H__
#define __ASDX_TIMER_H__

//-----------------------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------------------
#include <Windows.h>


namespace asdx {

////////////////////////////////////////////////////////////////////////////////////
// Timer class
////////////////////////////////////////////////////////////////////////////////////
class Timer
{
    //============================================================================
    // list of friend classes and methods.
    //============================================================================
    /* NOTHING */

private:
    //============================================================================
    // private variables
    //============================================================================
    bool        m_IsStop;               //!< ~Ԃǂ.
    LONGLONG    m_TicksPerSec;          //!< 1b̃^C}[ݐ.
    LONGLONG    m_StopTime;             //!< ~.
    LONGLONG    m_ElapsedTime;          //!< Ō̏oߎԂł.
    LONGLONG    m_BaseTime;             //!< ^C}[̊JnԂł.
    double      m_InvTicksPerSec;       //!< 1^C}[ݐ̕b.

    //============================================================================
    // private methods
    //============================================================================

    //----------------------------------------------------------------------------
    //! @brief      ꂽݎԂ擾܂.
    //----------------------------------------------------------------------------
    LARGE_INTEGER     GetAdjustedCurrentTime( void )
    {
        LARGE_INTEGER qwTime;

        // ~Ԃł΁C~Ԃԋp.
        if ( m_StopTime != 0 )
        { qwTime.QuadPart = m_StopTime; }
        // ~ԂȂ΁C݂̃JE^擾.
        else
        { QueryPerformanceCounter( &qwTime ); }

        return qwTime;
    }

protected:
    //============================================================================
    // protected variables
    //============================================================================
    /* NOTHING */

    //============================================================================
    // protected methods
    //============================================================================
    /* NOTHING */

public:
    //============================================================================
    // private variables
    //============================================================================
    /* NOTHING */

    //============================================================================
    // private methods
    //============================================================================

    //----------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------
    Timer::Timer()
    : m_IsStop     ( true )
    , m_StopTime   ( 0 )
    , m_ElapsedTime( 0 )
    , m_BaseTime   ( 0 )
    {
        LARGE_INTEGER qwTicksPerSec = { 0 };

        // g擾܂.
        QueryPerformanceFrequency( &qwTicksPerSec );

        m_TicksPerSec = qwTicksPerSec.QuadPart;
        m_InvTicksPerSec = 1.0 / static_cast<double>( m_TicksPerSec );
    }

    //----------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------
    ~Timer()
    { /* DO_NOTHING */ }

    //----------------------------------------------------------------------------
    //! @brief      ^C}[Zbg܂.
    //----------------------------------------------------------------------------
    void    Reset           ( void )
    {
        // ꂽݎԂ擾.
        LARGE_INTEGER qwTime = GetAdjustedCurrentTime();

        m_BaseTime    = qwTime.QuadPart;
        m_ElapsedTime = qwTime.QuadPart;
        m_StopTime    = 0;
        m_IsStop      = false;
    }

    //----------------------------------------------------------------------------
    //! @brief      ^C}[Jn܂.
    //----------------------------------------------------------------------------
    void    Start           ( void )
    {
        LARGE_INTEGER qwTime = { 0 };

        // ݂̃JE^擾.
        QueryPerformanceCounter( &qwTime );

        // ~Ȃx[XԂZ.
        if ( m_IsStop )
        { m_BaseTime += qwTime.QuadPart - m_StopTime; }

        m_StopTime    = 0;
        m_ElapsedTime = qwTime.QuadPart;
        m_IsStop       = false;
    }

    //----------------------------------------------------------------------------
    //! @brief      ^C}[~܂.
    //----------------------------------------------------------------------------
    void    Stop            ( void )
    {
        if ( !m_IsStop )
        {
            LARGE_INTEGER qwTime = { 0 };

            // ݂̃JE^擾.
            QueryPerformanceCounter( &qwTime );

            m_StopTime    = qwTime.QuadPart;
            m_ElapsedTime = qwTime.QuadPart;
            m_IsStop      = true;
        }
    }

    //----------------------------------------------------------------------------
    //! @brief      0.1b^C}[i߂܂.
    //----------------------------------------------------------------------------
    void    Advance         ( void )
    { m_StopTime += m_TicksPerSec / 10; }

    //----------------------------------------------------------------------------
    //! @brief      ~Ԃǂ肵܂.
    //!
    //! @retval true    ~.
    //! @retval false   ~.
    //----------------------------------------------------------------------------
    bool    IsStop          ( void ) const
    { return m_IsStop; }

    //----------------------------------------------------------------------------
    //! @brief      VXeԂ擾܂.
    //!
    //! @return     VXeԂԋp܂.
    //----------------------------------------------------------------------------
    double     GetAbsoluteTime ( void )
    {
        LARGE_INTEGER qwTime = { 0 };

        // ݂̃JE^擾.
        QueryPerformanceCounter( &qwTime );

        // VXeԂZoāCԋp.
        return qwTime.QuadPart * m_InvTicksPerSec;
    }

    //----------------------------------------------------------------------------
    //! @brief      ΎԂ擾܂.
    //!
    //! @return     ΎԂԋp܂.
    //----------------------------------------------------------------------------
    double     GetTime         ( void )
    {
        // ꂽݎԂ擾.
        register LARGE_INTEGER qwTime = GetAdjustedCurrentTime();

        // ԂZo.
        return ( qwTime.QuadPart - m_BaseTime ) * m_InvTicksPerSec;
    }

    //----------------------------------------------------------------------------
    //! @brief      oߎԂ擾܂.
    //!
    //! @return     oߎԂԋp܂.
    //----------------------------------------------------------------------------
    double     GetElapsedTime  ( void )
    {
        // ꂽݎԂ擾.
        register LARGE_INTEGER qwTime = GetAdjustedCurrentTime();

        // oߎԂZo.
        register double elapsedTime = ( qwTime.QuadPart - m_ElapsedTime ) * m_InvTicksPerSec;

        // oߎԂXV.
        m_ElapsedTime = qwTime.QuadPart;

        // 0ȉł΃v.
        if ( elapsedTime < 0 )
        { elapsedTime = 0.0; }

        return elapsedTime;
    }

    //----------------------------------------------------------------------------
    //! @brief      Ԃ̒l擾܂.
    //!
    //! @param [out]    time           ΎԂi[ϐ.
    //! @param [out]    absoluteTime   VXeԂi[ϐ.
    //! @param [out]    elapsedTime    oߎԂi[ϐ.
    //----------------------------------------------------------------------------
    void    GetValues   ( double& time, double& absoluteTime, double& elapsedTime )
    {
        // ꂽݎԂ擾.
        LARGE_INTEGER qwTime = GetAdjustedCurrentTime();

        // oߎԂ擾.
        register double diffTime = ( qwTime.QuadPart - m_ElapsedTime ) * m_InvTicksPerSec;

        // oߎԂXV.
        m_ElapsedTime = qwTime.QuadPart;

        // 0ȉł΃Nv.
        if ( diffTime < 0 )
        { diffTime = 0.0; }

        // VXe.
        absoluteTime = qwTime.QuadPart * m_InvTicksPerSec;

        // Ύ.
        time         = ( qwTime.QuadPart - m_BaseTime ) * m_InvTicksPerSec;

        // oߎ.
        elapsedTime  = diffTime;
    }
};

/////////////////////////////////////////////////////////////////////////////////////////////
// StopWatch class
/////////////////////////////////////////////////////////////////////////////////////////////
class StopWatch
{
    //=======================================================================================
    // list of friend classes and methods.
    //=======================================================================================
    /* NOTHING */

private:
    //=======================================================================================
    // private variables.
    //=======================================================================================
    LONGLONG    m_TicksPerSec;          //!< 1b̃^C}[ݐ.
    LONGLONG    m_StartTime;            //!< Jn.
    LONGLONG    m_EndTime;              //!< ~.
    double      m_InvTicksPerSec;       //!< 1^C}[ݐ̕b.

    //=======================================================================================
    // private methods.
    //=======================================================================================
    /* NOTHING */

protected:
    //=======================================================================================
    // protected variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // protected methods.
    //=======================================================================================
    /* NOTHING */

public:
    //=======================================================================================
    // public variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // public methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------
    StopWatch()
    : m_StartTime( 0 )
    , m_EndTime  ( 0 )
    {
        LARGE_INTEGER qwTime = { 0 };
        QueryPerformanceFrequency( &qwTime );
        m_TicksPerSec = qwTime.QuadPart;
        m_InvTicksPerSec = 1.0 / static_cast<double>( m_TicksPerSec );
    }

    //---------------------------------------------------------------------------------------
    //! @brief      vJn܂.
    //---------------------------------------------------------------------------------------
    void Start()
    {
        LARGE_INTEGER qwTime = { 0 };
        QueryPerformanceCounter( &qwTime );
        m_StartTime = qwTime.QuadPart;
    }

    //---------------------------------------------------------------------------------------
    //! @brief      vI܂.
    //---------------------------------------------------------------------------------------
    void End()
    {
        LARGE_INTEGER qwTime = { 0 };
        QueryPerformanceCounter( &qwTime );
        m_EndTime = qwTime.QuadPart;
    }

    //---------------------------------------------------------------------------------------
    //! @brief      oߎԂbPʂŎ擾܂.
    //!
    //! @return     oߎԂbPʂŕԋp܂.
    //---------------------------------------------------------------------------------------
    double GetElapsedTimeSec()
    {
         return ( m_EndTime - m_StartTime ) * m_InvTicksPerSec;
    }

    //---------------------------------------------------------------------------------------
    //! @brief      oߎԂ~bPʂŎ擾܂.
    //!
    //! @return     oߎԂ~bPʂŕԋp܂.
    //---------------------------------------------------------------------------------------
    double GetElapsedTimeMsec()
    {
        return ( m_EndTime - m_StartTime ) * 1000.0 * m_InvTicksPerSec;
    }
};

} // namespace asdx

#endif//__ASDX_TIMER_H__