//-------------------------------------------------------------------------------------------
// File : asdxAxisRenderer.h
// Desc : Axis Renderer Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_AXIS_RENDERER_H__
#define __ASDX_AXIS_RENDERER_H__

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------
#include <asdxMath.h>
#include <d3d11.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
// AxisRenderer class
//////////////////////////////////////////////////////////////////////////////////////////////
class AxisRenderer
{
    //========================================================================================
    // list of friend classes and methods.
    //========================================================================================
    /* NOTHING */

public:
    //========================================================================================
    // public variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // public methods.
    //========================================================================================

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    AxisRenderer();

    //----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------------
    virtual ~AxisRenderer();

    //----------------------------------------------------------------------------------------
    //! @brief      s܂.
    //----------------------------------------------------------------------------------------
    bool Init( ID3D11Device* pDevice );

    //----------------------------------------------------------------------------------------
    //! @brief      Is܂.
    //----------------------------------------------------------------------------------------
    void Term();

    //----------------------------------------------------------------------------------------
    //! @brief      `Jnł.
    //----------------------------------------------------------------------------------------
    void Begin(
        ID3D11DeviceContext* pDeviceContext, 
        const asdx::MATRIX& view,
        const asdx::MATRIX& proj );

    //----------------------------------------------------------------------------------------
    //! @brief      `悵܂.
    //----------------------------------------------------------------------------------------
    void Render( 
        ID3D11DeviceContext* pDeviceContext,
        const asdx::FLOAT3 position,
        const float scale = 1.0f );

    //----------------------------------------------------------------------------------------
    //! @brief      `Ił.
    //----------------------------------------------------------------------------------------
    void End( ID3D11DeviceContext* pDeviceContext );

protected:
    //========================================================================================
    // protected variables.
    //========================================================================================
    ID3D11Buffer*               m_pVB;      //!< _obt@ł.
    ID3D11Buffer*               m_pCB0;     //!< 萔obt@(Xbg0)ł.
    ID3D11Buffer*               m_pCB1;     //!< 萔obt@(Xbg1)ł.
    ID3D11VertexShader*         m_pVS;      //!< _VF[_ł.
    ID3D11PixelShader*          m_pPS;      //!< sNZVF[_ł.
    ID3D11InputLayout*          m_pIL;      //!< ̓CAEgł.
    ID3D11DepthStencilState*    m_pDSS;     //!< [xXeVXe[gł.

    //========================================================================================
    // protected methods.
    //========================================================================================
    /* NOTHING */

private:
    //========================================================================================
    // private variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // private methods.
    //========================================================================================
    AxisRenderer    ( const AxisRenderer& renderer );       // ANZX֎~.
    void operator = ( const AxisRenderer& renderer );       // ANZX֎~.
};

} // namespace asdx

#endif//__ASDX_CAMERA_RENDERER_H__
