//---------------------------------------------------------------------------------------
// File : SampleApp.cpp
// Desc : Sample Application
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------
#include "SampleApp.h"
#include <asdxLog.h>
#include <asdxShader.h>




/////////////////////////////////////////////////////////////////////////////////////////
// SampleApplication class
/////////////////////////////////////////////////////////////////////////////////////////

//---------------------------------------------------------------------------------------
//      RXgN^ł.
//---------------------------------------------------------------------------------------
SampleApplication::SampleApplication()
: Application   ( "Sample 02" )
, m_pSprites    ( nullptr )
, m_pFont       ( nullptr )
, m_pVB         ( nullptr )
, m_pIB         ( nullptr )
, m_pMB         ( nullptr )
, m_pTB         ( nullptr )
, m_pIL         ( nullptr )
, m_pVS         ( nullptr )
, m_pPS         ( nullptr )
, m_Stride      ( 0 )
, m_Offset      ( 0 )
, m_SubsetCount ( 0 )
, m_pSubset     ( nullptr )
{ /* DO_NOTHING */ }

//---------------------------------------------------------------------------------------
//      fXgN^ł.
//---------------------------------------------------------------------------------------
SampleApplication::~SampleApplication()
{ /* DO_NOTHING */ }

//---------------------------------------------------------------------------------------
//      ̏ł.
//---------------------------------------------------------------------------------------
bool SampleApplication::OnInit()
{
    // XvCgob`𐶐.
    m_pSprites = new DirectX::SpriteBatch( m_pDeviceContext );
    if ( m_pSprites == nullptr )
    {
        ELOG( "Error : Memory Allocate Failed." );
        return false;
    }

    // ˃tHg~j-Pǂݍ݃XvCgtHg쐬.
    m_pFont = new DirectX::SpriteFont( m_pDevice, L"../res/SetoMini-P.spritefont" );
    if ( m_pFont == nullptr )
    {
        ELOG( "Error : Memory Allocate Failed." );
        return false;
    }

    // bV[h܂.
    asdx::Mesh mesh;
    if ( !mesh.LoadFromFile( "../res/dosei.msh" ) )
    {
        ELOG( "Error : Mesh Load Failed." );
        return false;
    }

    HRESULT hr = S_OK;
    {
        ID3DBlob* pVSBlob = nullptr;

        // _VF[_RpC.
        hr = asdx::ShaderHelper::CompileShaderFromFile( 
            L"../res/SimpleVS.fx",
            "VSFunc",
            asdx::ShaderHelper::VS_4_0,
            &pVSBlob
        );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : CompileShaderFromFile() Failed." );
            return false;
        }

        // _VF[_𐶐.
        hr = m_pDevice->CreateVertexShader( pVSBlob->GetBufferPointer(), pVSBlob->GetBufferSize(), nullptr, &m_pVS );
        if ( FAILED( hr ) )
        {
            pVSBlob->Release();
            pVSBlob = nullptr;

            ELOG( "Error : ID3D11Device::CreateVertexShader() Failed." );
            return false;
        }

        // ̓CAEg𐶐.
        hr = m_pDevice->CreateInputLayout( 
            asdx::Mesh::INPUT_ELEMENTS,
            asdx::Mesh::NUM_INPUT_ELEMENT,
            pVSBlob->GetBufferPointer(),
            pVSBlob->GetBufferSize(),
            &m_pIL );

        pVSBlob->Release();
        pVSBlob = nullptr;

        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11Device::CreateInputLayout() Failed." );
            return false;
        }
    }

    {
        ID3DBlob* pPSBlob = nullptr;

        // sNZVF[_RpC.
        hr = asdx::ShaderHelper::CompileShaderFromFile(
            L"../res/SimplePS.fx",
            "PSFunc",
            asdx::ShaderHelper::PS_4_0,
            &pPSBlob 
        );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : CompileShaderFromFile() Failed." );
            return false;
        }

        // sNZVF[_𐶐.
        hr = m_pDevice->CreatePixelShader(
            pPSBlob->GetBufferPointer(),
            pPSBlob->GetBufferSize(),
            nullptr,
            &m_pPS
        );

        pPSBlob->Release();
        pPSBlob = nullptr;

        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11CreatePixelShader() Failed." );
            return false;
        }
    }

    {
        // _obt@̐ݒ.
        D3D11_BUFFER_DESC bd;
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        bd.Usage          = D3D11_USAGE_DEFAULT;
        bd.ByteWidth      = sizeof( asdx::Mesh::Vertex ) * mesh.GetVertexCount();
        bd.BindFlags      = D3D11_BIND_VERTEX_BUFFER;
        bd.CPUAccessFlags = 0;

        m_Stride = sizeof( asdx::Mesh::Vertex );
        m_Offset = 0;

        // _f[^ݒ.
        D3D11_SUBRESOURCE_DATA sd;
        ZeroMemory( &sd, sizeof( D3D11_SUBRESOURCE_DATA ) );
        sd.pSysMem = mesh.GetVertices();

        // _obt@𐶐.
        hr = m_pDevice->CreateBuffer( &bd, &sd, &m_pVB );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11Device::CreateBuffer() Failed." );
            return false;
        }

        // CfbNXobt@̐ݒ.
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        ZeroMemory( &sd, sizeof( D3D11_SUBRESOURCE_DATA ) );
        bd.Usage          = D3D11_USAGE_DEFAULT;
        bd.ByteWidth      = sizeof( asdx::UINT ) * mesh.GetIndexCount();
        bd.BindFlags      = D3D11_BIND_INDEX_BUFFER;
        bd.CPUAccessFlags = 0;

        // CfbNXf[^ݒ.
        sd.pSysMem = mesh.GetIndices();

        // CfbNXobt@𐶐.
        hr = m_pDevice->CreateBuffer( &bd, &sd, &m_pIB );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11Device::CreateBuffer() Failed." );
            return false;
        }

        // }eAobt@̐ݒ.
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        bd.Usage          = D3D11_USAGE_DEFAULT;
        bd.ByteWidth      = sizeof( SimpleMaterial );
        bd.BindFlags      = D3D11_BIND_CONSTANT_BUFFER;
        bd.CPUAccessFlags = 0;

        // }eAobt@𐶐.
        hr = m_pDevice->CreateBuffer( &bd, nullptr, &m_pMB );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11Device::CreateBuffer() Failed." );
            return false;
        }

        // ϊp[^obt@̐ݒ.
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        bd.Usage          = D3D11_USAGE_DEFAULT;
        bd.ByteWidth      = sizeof( TransformParam );
        bd.BindFlags      = D3D11_BIND_CONSTANT_BUFFER;
        bd.CPUAccessFlags = 0;

        // ϊp[^obt@𐶐.
        hr = m_pDevice->CreateBuffer( &bd, nullptr, &m_pTB );
        if ( FAILED( hr ) )
        {
            ELOG( "Error : ID3D11Device::CreateBuffer() Failed." );
            return false;
        }

        // AXyNgZo.
        float aspectRatio = (float)m_Width/(float)m_Height;

        // J̐ݒ.
        m_Camera.GetCamera().SetPosition( asdx::FLOAT3( 0.0f, 0.0f, -50.0f ) );
        m_Camera.GetCamera().SetTarget( asdx::FLOAT3( 0.0f, 0.0f, 0.0f ) );
        m_Camera.GetCamera().SetUpward( asdx::FLOAT3( 0.0f, 1.0f, 0.0f ) );
        m_Camera.GetCamera().Preset();
        m_Camera.GetCamera().Update();

        // ϊp[^ݒ.
        m_TransformParam.Light = asdx::FLOAT4( 0.0f, -1.0f, 1.0f, 0.0f );
        m_TransformParam.Proj  = asdx::CreatePerspectiveFieldOfView( asdx::F_PIDIV4, aspectRatio, 0.1f, 100000.0f );
        m_TransformParam.View  = m_Camera.GetView();
        m_TransformParam.World.Identity();

    }

    // TuZbggݗĂ.
    {
        m_SubsetCount = mesh.GetSubsetCount();
        m_pSubset = new SimpleSubset[ mesh.GetSubsetCount() ];
        if ( m_pSubset == nullptr )
        {
            ELOG( "Error : Memory Allocate Failed." );
            return false;
        }

        SimpleMaterial material;
        for( asdx::UINT i=0; i<mesh.GetSubsetCount(); ++i )
        {
            asdx::Mesh::Subset   subset = mesh.GetSubset( i );
            asdx::Mesh::Material mat    = mesh.GetMatrial( subset.MaterialID );

            // gUːFݒ.
            material.Diffuse.x = mat.Diffuse.x;
            material.Diffuse.y = mat.Diffuse.y;
            material.Diffuse.z = mat.Diffuse.z;

            // ߓxݒ.
            material.Diffuse.w = mat.Alpha;

            // ʔːFݒ.
            material.Spcular.x = mat.Specular.x;
            material.Spcular.y = mat.Specular.y;
            material.Spcular.z = mat.Specular.z;
            material.Spcular.w = mat.Power;

            // TuZbgݒ.
            m_pSubset[ i ].IndexCount  = subset.IndexCount;
            m_pSubset[ i ].IndexOffset = subset.IndexOffset;
            m_pSubset[ i ].Material    = material;
        }

        // svȃ.
        mesh.Release();
    }

    return true;
}

//---------------------------------------------------------------------------------------
//      Ȉł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnTerm()
{
    // XvCgob`.
    if ( m_pSprites )
    {
        delete m_pSprites;
        m_pSprites = nullptr;
    }

    // XvCgtHg.
    if ( m_pFont )
    {
        delete m_pFont;
        m_pFont = nullptr;
    }

    // _VF[_.
    if ( m_pVS )
    {
        m_pVS->Release();
        m_pVS = nullptr;
    }

    // sNZVF[_.
    if ( m_pPS )
    {
        m_pPS->Release();
        m_pPS = nullptr;
    }

    // ̓CAEg.
    if ( m_pIL )
    { 
        m_pIL->Release();
        m_pIL = nullptr;
    }

    // _obt@.
    if ( m_pVB )
    {
        m_pVB->Release();
        m_pVB = nullptr;
    }

    // CfbNXobt@.
    if ( m_pIB )
    {
        m_pIB->Release();
        m_pIB = nullptr;
    }

    // }eAobt@.
    if ( m_pMB )
    {
        m_pMB->Release();
        m_pMB = nullptr;
    }

    // ϊp[^obt@.
    if ( m_pTB )
    {
        m_pTB->Release();
        m_pTB = nullptr;
    }

    // TuZbg.
    if ( m_pSubset )
    {
        delete [] m_pSubset;
        m_pSubset = nullptr;
    }

    // JEg[ɐݒ.
    m_Stride      = 0;
    m_Offset      = 0;
    m_SubsetCount = 0;
}

//---------------------------------------------------------------------------------------
//      t[Jڎ̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnFrameMove( double time, double elapsedTime )
{
    // r[sXV.
    m_TransformParam.View = m_Camera.GetView();

    // FPSeLXgXV.
    swprintf_s( m_FpsText, L"FPS : %.02f", GetFPS() );
}

//---------------------------------------------------------------------------------------
//      eLXg`掞̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnDrawText()
{
    // ݒNA܂.
    m_pDeviceContext->VSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->GSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->DSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->HSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->PSSetShader( nullptr, nullptr, 0 );

    // eLXg`揈ł.
    m_pSprites->Begin();
    {
        DirectX::XMFLOAT2 pos;
        pos.x = 5.0f;
        pos.y = 5.0f;

        m_pFont->DrawString( m_pSprites, m_FpsText, pos );
    }
    m_pSprites->End();
}

//---------------------------------------------------------------------------------------
//      bV`掞̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnDrawMesh()
{
    // VF[_̐ݒ.
    m_pDeviceContext->VSSetShader( m_pVS,   nullptr, 0 );
    m_pDeviceContext->GSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->HSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->DSSetShader( nullptr, nullptr, 0 );
    m_pDeviceContext->PSSetShader( m_pPS,   nullptr, 0 );

    // _obt@ݒ.
    m_pDeviceContext->IASetVertexBuffers( 0, 1, &m_pVB, &m_Stride, &m_Offset );

    // ̓CAEgݒ.
    m_pDeviceContext->IASetInputLayout( m_pIL );

    // ϊp[^obt@XV.
    m_pDeviceContext->UpdateSubresource( m_pTB, 0, nullptr, &m_TransformParam, 0, 0 );

    // _VF[_ɒ萔obt@ݒ.
    m_pDeviceContext->VSSetConstantBuffers( 1, 1, &m_pTB );

    // CfbNXobt@ݒ.
    m_pDeviceContext->IASetIndexBuffer( m_pIB, DXGI_FORMAT_R32_UINT, 0 );

    // v~eBug|W[ݒ.
    m_pDeviceContext->IASetPrimitiveTopology( D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST );

    // TuZbg[v.
    for( asdx::UINT i=0; i<m_SubsetCount; ++i )
    {
        // }eAobt@XV.
        m_pDeviceContext->UpdateSubresource( m_pMB, 0, nullptr, &m_pSubset[ i ].Material, 0, 0 );

        // sNZVF[_ɒ萔obt@ݒ.
        m_pDeviceContext->PSSetConstantBuffers( 0, 1, &m_pMB );

        // CfbNXtŕ`.
        m_pDeviceContext->DrawIndexed( m_pSubset[ i ].IndexCount, m_pSubset[ i ].IndexOffset, 0 );
    }
}

//---------------------------------------------------------------------------------------
//      `掞̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnFrameRender( double time, double elapsedTime )
{
    // _[^[Qbgr[E[xXeVr[擾.
    ID3D11RenderTargetView* pRTV = m_RenderTarget2D.GetRTV();
    ID3D11DepthStencilView* pDSV = m_DepthStencilBuffer.GetDSV();

    // NULL`FbN.
    if ( pRTV == nullptr )
    { return; }
    if ( pDSV == nullptr )
    { return; }
    
    // o̓}l[Wɐݒ.
    m_pDeviceContext->OMSetRenderTargets( 1, &pRTV, pDSV );

    // NA.
    m_pDeviceContext->ClearRenderTargetView( pRTV, m_ClearColor );
    m_pDeviceContext->ClearDepthStencilView( pDSV, D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0f, 0 );

    // Xe[gݒ.
    m_pDeviceContext->RSSetState( m_pRasterizerState );
    m_pDeviceContext->OMSetBlendState( m_pBlendState, m_BlendFactor, m_SampleMask );
    m_pDeviceContext->OMSetDepthStencilState( m_pDepthStencilState, m_StencilRef );

    // `揈.
    {
        // bV`.
        OnDrawMesh();

        // eLXg`.
        OnDrawText();
    }

    // R}hsāCʂɕ\.
    m_pSwapChain->Present( 0, 0 );
}

//---------------------------------------------------------------------------------------
//      TCYCxg̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnResize( const asdx::ResizeEventParam& param )
{
    // ˉesXV.
    m_TransformParam.Proj = asdx::CreatePerspectiveFieldOfView( asdx::F_PIDIV4, param.AspectRatio, 0.1f, 1000.0f );
}

//---------------------------------------------------------------------------------------
//      L[Cxg̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnKey( const asdx::KeyEventParam& param )
{
    // J.
    m_Camera.OnKey( param.KeyCode, param.IsKeyDown, param.IsAltDown );
}

//---------------------------------------------------------------------------------------
//      }EXCxg̏ł.
//---------------------------------------------------------------------------------------
void SampleApplication::OnMouse( const asdx::MouseEventParam& param )
{
    // J.
    m_Camera.OnMouse( 
        param.X,
        param.Y,
        param.WheelDelta,
        param.IsLeftButtonDown,
        param.IsRightButtonDown,
        param.IsMiddleButtonDown,
        param.IsSideButton1Down,
        param.IsSideButton2Down
    );
}
