//------------------------------------------------------------------------------------------
// File : dfw_RenderTarget2D.cpp
// Desc : RenderTarget2D Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include <cassert>
#include <asdxRenderTarget.h>
#include <asdxUtil.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////
// RenderTarget2D class
///////////////////////////////////////////////////////////////////////////////////////////////

//---------------------------------------------------------------------------------------------
//      RXgN^ł.
//---------------------------------------------------------------------------------------------
RenderTarget2D::RenderTarget2D()
: m_pTexture( nullptr )
, m_pSRV    ( nullptr )
, m_pRTV    ( nullptr )
{ /* DO_NOTHING */ }

//---------------------------------------------------------------------------------------------
//      fXgN^ł.
//---------------------------------------------------------------------------------------------
RenderTarget2D::~RenderTarget2D()
{ Release(); }

//---------------------------------------------------------------------------------------------
//      obNobt@`^[Qbg𐶐܂.
//---------------------------------------------------------------------------------------------
bool RenderTarget2D::CreateFromBackBuffer( ID3D11Device* pDevice, IDXGISwapChain* pSwapChain )
{
    HRESULT hr = S_OK;

    // obNobt@擾.
    hr = pSwapChain->GetBuffer( 0, IID_ID3D11Texture2D, (LPVOID*)&m_pTexture );
    if( FAILED( hr ) )
    {
        // G[Oo.
        OutputDebugStringA( "Error : IDXGISwapChain->GetBuffer() Failed. call from RenderTarget2D::CreateFromBackBuffer()" );

        // s.
        return false;
    }
    SetDebugObjectName( m_pTexture, "asdxRenderTarget" );

    // _[^[Qbgr[𐶐.
    hr = pDevice->CreateRenderTargetView( m_pTexture, nullptr, &m_pRTV );
    if ( FAILED( hr ) )
    {
        // obNobt@.
        m_pTexture->Release();
        m_pTexture = nullptr;

        // G[Oo.
        OutputDebugStringA( "Error : ID3D11Device::CreateRenderTargetView() Failed. call from RenderTarget2D::CreateFromBackBuffer()" );

        // s.
        return false;
    }
    SetDebugObjectName( m_pRTV, "asdxRenderTarget" );

    // VF[_\[Xr[𐶐.
    hr = pDevice->CreateShaderResourceView( m_pTexture, nullptr, &m_pSRV );
    if ( FAILED( hr ) )
    {
        // eNX`.
        m_pTexture->Release();
        m_pTexture = nullptr;

        // _[^[Qbgr[.
        m_pRTV->Release();
        m_pRTV = nullptr;

        // G[Oo.
        OutputDebugStringA( "Error : ID3D11Device::CreateShaderResourcdeView() Failed. call from RenderTarget2D::CreateFromBackBuffer()" );

        // s.
        return false;
    }
    SetDebugObjectName( m_pSRV, "asdxRenderTarget" );

    // .
    return true;
}

//---------------------------------------------------------------------------------------------
//      `^[Qbg𐶐܂.
//---------------------------------------------------------------------------------------------
bool RenderTarget2D::Create( ID3D11Device* pDevice, const RenderTarget2D::Description& desc )
{
    assert( desc.ArraySize >= 1 );
    HRESULT hr = S_OK;

    // eNX`̐ݒ.
    D3D11_TEXTURE2D_DESC td;
    td.Width                = desc.Width;
    td.Height               = desc.Height;
    td.MipLevels            = desc.MipLevels;
    td.ArraySize            = desc.ArraySize;
    td.Format               = desc.Format;
    td.SampleDesc.Count     = desc.SampleDesc.Count;
    td.SampleDesc.Quality   = desc.SampleDesc.Quality;
    td.Usage                = D3D11_USAGE_DEFAULT;
    td.BindFlags            = D3D11_BIND_RENDER_TARGET | D3D11_BIND_SHADER_RESOURCE;
    td.CPUAccessFlags       = desc.CPUAccessFlags;
    td.MiscFlags            = desc.MiscFlags;

    // eNX`𐶐܂.
    hr = pDevice->CreateTexture2D( &td, nullptr, &m_pTexture );
    if ( FAILED( hr ) )
    {
        // G[Oo.
        OutputDebugStringA( "Error : ID3D11Device::CreateTexture2D() Failed. call from RenderTarget2D::Create()" );

        // s.
        return false;
    }
    SetDebugObjectName( m_pTexture, "asdxRenderTarget" );

    // _[^[Qbgr[̐ݒ.
    D3D11_RENDER_TARGET_VIEW_DESC rtvd;
    ZeroMemory( &rtvd, sizeof( D3D11_RENDER_TARGET_VIEW_DESC ) );
    rtvd.Format = desc.Format;

    // zTCY1̏ꍇ.
    if ( desc.ArraySize == 1 )
    {
        // }`TvȌꍇ.
        if ( desc.SampleDesc.Count == 0 )
        {
            rtvd.ViewDimension      = D3D11_RTV_DIMENSION_TEXTURE2D;
            rtvd.Texture2D.MipSlice = 0;
        }
        // }`TvOL̏ꍇ.
        else
        {
            rtvd.ViewDimension = D3D11_RTV_DIMENSION_TEXTURE2DMS;
        }
    }
    // zTCY1傫ꍇ.
    else
    {
        // }`TvȌꍇ.
        if ( desc.SampleDesc.Count == 0 )
        {
            rtvd.ViewDimension                  = D3D11_RTV_DIMENSION_TEXTURE2DARRAY;
            rtvd.Texture2DArray.ArraySize       = desc.ArraySize;
            rtvd.Texture2DArray.FirstArraySlice = 0;
            rtvd.Texture2DArray.MipSlice        = 0;
        }
        // }`TvOL̏ꍇ.
        else
        {
            rtvd.ViewDimension                    = D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY;
            rtvd.Texture2DMSArray.ArraySize       = desc.ArraySize;
            rtvd.Texture2DMSArray.FirstArraySlice = 0;
        }
    }

    // _[^[Qbgr[𐶐.
    hr = pDevice->CreateRenderTargetView( m_pTexture, &rtvd, &m_pRTV );
    if ( FAILED( hr ) )
    {
        // eNX`.
        m_pTexture->Release();
        m_pTexture = nullptr;

        // G[Oo.
        OutputDebugStringA( "Error : ID3D11Device::CreateRenderTargetView() Failed. call from RenderTarget2D::Create()" );

        // s.
        return false;
    }
    SetDebugObjectName( m_pRTV, "asdxRenderTarget" );

    // VF[_\[Xr[̐ݒ.
    D3D11_SHADER_RESOURCE_VIEW_DESC srvd;
    ZeroMemory( &srvd, sizeof( D3D11_SHADER_RESOURCE_VIEW_DESC ) );
    srvd.Format = desc.Format;

    // zTCY1̏ꍇ.
    if ( desc.ArraySize == 1 )
    {
        // }`TvȌꍇ.
        if ( desc.SampleDesc.Count == 0 )
        {
            srvd.ViewDimension             = D3D11_SRV_DIMENSION_TEXTURE2D;
            srvd.Texture2D.MipLevels       = desc.MipLevels;
            srvd.Texture2D.MostDetailedMip = 0;
        }
        // }`TvOL̏ꍇ.
        else
        {
            srvd.ViewDimension = D3D11_SRV_DIMENSION_TEXTURE2DMS;
        }
    }
    // zTCY1傫ꍇ.
    else
    {
        // }`TvȌꍇ.
        if ( desc.SampleDesc.Count == 0 )
        {
            srvd.ViewDimension                  = D3D11_SRV_DIMENSION_TEXTURE2DARRAY;
            srvd.Texture2DArray.ArraySize       = desc.ArraySize;
            srvd.Texture2DArray.FirstArraySlice = 0;
            srvd.Texture2DArray.MipLevels       = desc.MipLevels;
            srvd.Texture2DArray.MostDetailedMip = 0;
        }
        // }`TvOL̏ꍇ.
        else
        {
            srvd.ViewDimension                    = D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY;
            srvd.Texture2DMSArray.ArraySize       = desc.ArraySize;
            srvd.Texture2DMSArray.FirstArraySlice = 0;
        }
    }

    // VF[_\[Xr[𐶐.
    hr = pDevice->CreateShaderResourceView( m_pTexture, &srvd, &m_pSRV );
    if ( FAILED( hr ) )
    {
        // eNX`.
        m_pTexture->Release();
        m_pTexture = nullptr;

        // _[^[Qbgr[.
        m_pRTV->Release();
        m_pRTV = nullptr;

        // G[Oo.
        OutputDebugStringA( "Error : ID3D11Device::CreateShaderResourceView() Failed. call from RenderTarget2D::Create()" );

        // s.
        return false;
    }
    SetDebugObjectName( m_pSRV, "asdxRenderTarget" );

    // .
    return true;
}

//---------------------------------------------------------------------------------------------
//      ł.
//---------------------------------------------------------------------------------------------
void RenderTarget2D::Release()
{
    // VF[_\[Xr[.
    if ( m_pSRV )
    {
        m_pSRV->Release();
        m_pSRV = nullptr;
    }

    // _[^[Qbgr[.
    if ( m_pRTV )
    {
        m_pRTV->Release();
        m_pRTV = nullptr;
    }

    // eNX`.
    if ( m_pTexture )
    {
        m_pTexture->Release();
        m_pTexture = nullptr;
    }
}

//---------------------------------------------------------------------------------------------
//      eNX`擾܂.
//---------------------------------------------------------------------------------------------
ID3D11Texture2D* RenderTarget2D::GetTexture() const
{ return m_pTexture; }

//---------------------------------------------------------------------------------------------
//      VF[_\[Xr[擾܂.
//---------------------------------------------------------------------------------------------
ID3D11ShaderResourceView* RenderTarget2D::GetSRV() const
{ return m_pSRV; }

//---------------------------------------------------------------------------------------------
//      _[^[Qbgr[擾܂.
//---------------------------------------------------------------------------------------------
ID3D11RenderTargetView* RenderTarget2D::GetRTV() const
{ return m_pRTV; }

} // namespace asdx

