//------------------------------------------------------------------------------------------
// File : asdxCameraUpdater.cpp
// Desc : Camera Update Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include <asdxCameraUpdater.h>


namespace asdx {

////////////////////////////////////////////////////////////////////////////////////////////
// CameraUpdate class
////////////////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------------------
//      RXgN^ł.
//------------------------------------------------------------------------------------------
CameraUpdater::CameraUpdater()
: m_Camera      ()
, m_MouseLeft   ()
, m_MouseRight  ()
, m_MouseMiddle ()
{ /* DO_NOTHING */ }

//------------------------------------------------------------------------------------------
//      fXgN^ł.
//------------------------------------------------------------------------------------------
CameraUpdater::~CameraUpdater()
{ /* DO_NOTHING */ }

//------------------------------------------------------------------------------------------
//      ݒs܂.
//------------------------------------------------------------------------------------------
void CameraUpdater::Init
(
    asdx::FLOAT3 cameraPos,
    asdx::FLOAT3 cameraAim,
    asdx::FLOAT3 cameraUp,
    float        nearClip,
    float        farClip
)
{
    m_Camera.SetPosition( cameraPos );
    m_Camera.SetTarget( cameraAim );
    m_Camera.SetUpward( cameraUp );
    m_Camera.SetRange( nearClip, farClip );

    m_Camera.Preset();
    m_Camera.Update();
}

//------------------------------------------------------------------------------------------
//      }EX̏ł.
//------------------------------------------------------------------------------------------
void CameraUpdater::OnMouse
(
    int  x,
    int  y,
    int  wheelDelta,
    bool isLeftButtonDown,
    bool isRightButtonDown,
    bool isMiddleButtonDown,
    bool isSideButton1Down,
    bool isSideButton2Down
)
{
    m_MouseLeft  .Update( x, y, isLeftButtonDown );
    m_MouseRight .Update( x, y, isRightButtonDown );
    m_MouseMiddle.Update( x, y, isMiddleButtonDown );

    CameraEvent e = MakeEventFromMouse( wheelDelta );
    m_Camera.UpdateByEvent( e );
}

//------------------------------------------------------------------------------------------
//      L[̏ł.
//------------------------------------------------------------------------------------------
void CameraUpdater::OnKey( unsigned int nChar, bool isKeyDown, bool isAltDown )
{
    CameraEvent e = MakeEventFromKey( nChar, isKeyDown, isAltDown );
    m_Camera.UpdateByEvent( e );
}

//------------------------------------------------------------------------------------------
//      J擾܂.
//------------------------------------------------------------------------------------------
Camera& CameraUpdater::GetCamera()
{ return m_Camera; }

//------------------------------------------------------------------------------------------
//      r[s擾܂.
//------------------------------------------------------------------------------------------
asdx::MATRIX CameraUpdater::GetView() const
{ return m_Camera.GetView(); }

//------------------------------------------------------------------------------------------
//      }EX͂JCxg𐶐܂.
//------------------------------------------------------------------------------------------
CameraEvent CameraUpdater::MakeEventFromMouse( int wheelDelta )
{
    CameraEvent result;
    unsigned int flags = 0;
    const float dollyGain = 0.1f;
    const float angleGain = 0.01f;
    const float moveGain  = 0.01f;
    const float wheelGain = 5.0f;

    // zC[Ńh[.
    if ( wheelDelta > 0 )
    {
        flags |= CameraEvent::EVENT_DOLLY;
        result.Dolly = wheelGain;
    }
    else if ( wheelDelta < 0 )
    {
        flags |= CameraEvent::EVENT_DOLLY;
        result.Dolly = -wheelGain;
    }

    // {^hbOŉ].
    if ( m_MouseLeft.isClick && ( !m_MouseRight.isClick ) && ( !m_MouseMiddle.isClick ) )
    {
        flags |= CameraEvent::EVENT_ROTATE;

        // ]ʂƂ.
        result.Rotate.x = ( m_MouseLeft.X - m_MouseLeft.prevX ) * angleGain;
        result.Rotate.y = ( m_MouseLeft.Y - m_MouseLeft.prevY ) * angleGain;
    }

    // E{^hbOŉ].
    if ( ( !m_MouseLeft.isClick ) && m_MouseRight.isClick && ( !m_MouseMiddle.isClick ) )
    {
        flags |= CameraEvent::EVENT_DOLLY;

        // h[ʂƂ.
        result.Dolly = ( m_MouseRight.Y - m_MouseRight.prevY ) * dollyGain;
    }

    // {E{^hbOŃpE`g.
    if ( m_MouseLeft.isClick && m_MouseRight.isClick )
    {
        flags |= CameraEvent::EVENT_PANTILT;

        // pE`gpƂ.
        result.PanTilt.x = ( m_MouseLeft.X - m_MouseLeft.prevX ) * angleGain;
        result.PanTilt.y = ( m_MouseLeft.Y - m_MouseLeft.prevY ) * angleGain;
    }

    // {^hbOŃgbN.
    if ( ( !m_MouseLeft.isClick ) && ( !m_MouseRight.isClick ) && m_MouseMiddle.isClick )
    {
        flags |= CameraEvent::EVENT_TRUCK;

        // xNgZo.
        asdx::FLOAT3 dir = m_Camera.GetTarget() - m_Camera.GetPosition();
        if ( dir.LengthSquared() != 0.0f )
        { dir.Normalize(); }

        // ExNgZo.
        asdx::FLOAT3 right = asdx::Cross( dir, m_Camera.GetUpward() );
        if ( right.LengthSquared() != 0.0f )
        { right.Normalize(); }

        asdx::FLOAT3 upward = m_Camera.GetUpward();

        // Zo.
        float rightGain  = ( m_MouseMiddle.X - m_MouseMiddle.prevX ) * moveGain;
        float upwardGain = ( m_MouseMiddle.Y - m_MouseMiddle.prevY ) * moveGain;

        // W.
        right.x  *= rightGain;
        right.y  *= rightGain;
        right.z  *= rightGain;
        upward.x *= upwardGain;
        upward.y *= upwardGain;
        upward.z *= upwardGain;

        // JԂŕsɓ.
        result.Truck.x = ( right.x + upward.x );
        result.Truck.y = ( right.y + upward.y );
        result.Truck.z = ( right.z + upward.z );
    }

    // {{^hbOŃcCXg.
    if ( m_MouseLeft.isClick && ( !m_MouseRight.isClick ) && m_MouseMiddle.isClick )
    {
        flags |= CameraEvent::EVENT_TWIST;

        // ʂcCXgpƂ.
        result.Twist = ( m_MouseLeft.X - m_MouseLeft.prevX ) * angleGain;
    }

    // tOݒ.
    result.Flags = flags;

    return result;
}

//------------------------------------------------------------------------------------------
//      L[͂JCxg𐶐.
//------------------------------------------------------------------------------------------
CameraEvent CameraUpdater::MakeEventFromKey( unsigned int nChar, bool isKeyDown, bool isAltDown )
{
    CameraEvent result;

    switch( nChar )
    {
    // RL[ŃZbg.
    case 0x52:
        if ( isKeyDown )
        { result.Flags |= CameraEvent::EVENT_RESET; }
        break;

    // TL[ŃcCXg
    case 0x54:
        if ( isAltDown && isKeyDown )
        {
            result.Flags |= CameraEvent::EVENT_TWIST;
            result.Twist = -0.1f;
        }
        else if ( !isAltDown && isKeyDown )
        {
            result.Flags |= CameraEvent::EVENT_TWIST;
            result.Twist = 0.1f;
        }
        break;
    }

    return result;
}

} // namespace asdx