//------------------------------------------------------------------------------------------
// File : asdxRenderTarget.h
// Desc : RenderTarget2D Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

#ifndef __ASDX_RENDER_TARGET_H__
#define __ASDX_RENDER_TARGET_H__

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include <d3d11.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////
// RenderTarget2D class
//////////////////////////////////////////////////////////////////////////////////////
class RenderTarget2D
{
    //================================================================================
    // list of friend classes and methods.
    //================================================================================
    /* NOTHING */

public:
    //////////////////////////////////////////////////////////////////////////////////
    // Description structure
    //////////////////////////////////////////////////////////////////////////////////
    struct Description
    {
        UINT                Width;          //!< ł.
        UINT                Height;         //!< cł.
        UINT                MipLevels;      //!< ~bvxł.
        UINT                ArraySize;      //!< zTCYł.
        DXGI_FORMAT         Format;         //!< tH[}bgł.
        DXGI_SAMPLE_DESC    SampleDesc;     //!< Tv̊Tvł.
        UINT                CPUAccessFlags; //!< CPUANZXtOł.
        UINT                MiscFlags;      //!< tOł.
    };

    //================================================================================
    // public variables
    //================================================================================
    /* NOTHING */

    //================================================================================
    // public methods
    //================================================================================

    //--------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //--------------------------------------------------------------------------------
    RenderTarget2D();

    //--------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //--------------------------------------------------------------------------------
    virtual ~RenderTarget2D();

    //--------------------------------------------------------------------------------
    //! @brief      obNobt@2`^[Qbg𐶐܂.
    //!
    //! @param [in]     pDevice     foCXł.
    //! @param [in]     pSwapChain  Xbv`FCł.
    //! @retval true    `^[Qbg̐ɐ.
    //! @retval false   `^[Qbg̐Ɏs.
    //--------------------------------------------------------------------------------
    bool CreateFromBackBuffer( ID3D11Device* pDevice, IDXGISwapChain* pSwapChain );

    //--------------------------------------------------------------------------------
    //! @brief      `^[Qbg𐶐܂.
    //!
    //! @param [in]     pDevice     foCXł.
    //! @param [in]     desc        Tvł.
    //! @retval true    `^[Qbg̐ɐ.
    //! @retval false   `^[Qbg̐Ɏs.
    //--------------------------------------------------------------------------------
    bool Create( ID3D11Device* pDevice, const Description& desc );

    //--------------------------------------------------------------------------------
    //! @brief      eNX`擾܂.
    //!
    //! @return     eNX`ԋp܂.
    //--------------------------------------------------------------------------------
    ID3D11Texture2D* GetTexture() const;

    //--------------------------------------------------------------------------------
    //! @brief      VF[_\[Xr[擾܂.
    //!
    //! @return     VF[_\[Xr[ԋp܂.
    //--------------------------------------------------------------------------------
    ID3D11ShaderResourceView* GetSRV() const;

    //--------------------------------------------------------------------------------
    //! @brief      _[^[Qbgr[擾܂.
    //!
    //! @return     _[^[Qbgr[ԋp܂.
    //--------------------------------------------------------------------------------
    ID3D11RenderTargetView* GetRTV() const;

    //--------------------------------------------------------------------------------
    //! @brief      s܂.
    //--------------------------------------------------------------------------------
    void Release();

protected:
    //================================================================================
    // protected variables
    //================================================================================
    /* NOTHING */

    //================================================================================
    // protected methods
    //================================================================================
    /* NOTHING */

private:
    //================================================================================
    // private variables
    //================================================================================
    ID3D11Texture2D*            m_pTexture;     //!< eNX`ł.
    ID3D11ShaderResourceView*   m_pSRV;         //!< VF[_\[Xr[ł.
    ID3D11RenderTargetView*     m_pRTV;         //!< _[^[Qbgr[ł.

    //================================================================================
    // private methods.
    //================================================================================
    RenderTarget2D  ( const RenderTarget2D& );  // ANZX֎~.
    void operator = ( const RenderTarget2D& );  // ANZX֎~.
};

} // namespace asdx

#endif//__ASDX_RENDER_TARGET_H__