//--------------------------------------------------------------------------------------------
// File : asdxDepthBuffer.h
// Desc : Depth Stencil Buffer Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_DEPTH_BUFFER_H__
#define __ASDX_DEPTH_BUFFER_H__

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------
#include <d3d11.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
// DepthStencilBuffer class
//////////////////////////////////////////////////////////////////////////////////////////////
class DepthStencilBuffer
{
public:
    //////////////////////////////////////////////////////////////////////////////////////////
    // Description structer
    //////////////////////////////////////////////////////////////////////////////////////////
    struct Description
    {
        UINT                Width;
        UINT                Height;
        UINT                MipLevels;
        UINT                ArraySize;
        DXGI_FORMAT         Format;
        DXGI_SAMPLE_DESC    SampleDesc;
        UINT                CPUAccessFlags;
        UINT                MiscFlags;
    };

    //=======================================================================================
    // public variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // public methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------
    DepthStencilBuffer();

    //---------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //---------------------------------------------------------------------------------------
    virtual ~DepthStencilBuffer();

    //---------------------------------------------------------------------------------------
    //! @brief      [xXeVobt@𐶐܂.
    //!
    //! @param [in]     pDevice     foCXł.
    //! @param [in]     desc        Tvł.
    //! @retval true    [xXeVobt@̐ɐ.
    //! @retval false   [xXeVobt@̐Ɏs.
    //---------------------------------------------------------------------------------------
    bool Create( ID3D11Device* pDevice, const Description& desc );

    //---------------------------------------------------------------------------------------
    //! @brief      eNX`擾܂.
    //!
    //! @retrun     eNX`ԋp܂.
    //---------------------------------------------------------------------------------------
    ID3D11Texture2D* GetTexture() const;

    //---------------------------------------------------------------------------------------
    //! @brief      VF[_\[Xr[擾܂.
    //!
    //! @return     VF[_\[Xr[ԋp܂.
    //---------------------------------------------------------------------------------------
    ID3D11ShaderResourceView* GetSRV() const;

    //---------------------------------------------------------------------------------------
    //! @brief      [xXeVr[擾܂.
    //!
    //! @return     [xXeVr[ԋp܂.
    //---------------------------------------------------------------------------------------
    ID3D11DepthStencilView* GetDSV() const;

    //---------------------------------------------------------------------------------------
    //! @brief      s܂.
    //---------------------------------------------------------------------------------------
    void Release();

protected:
    //=======================================================================================
    // protected variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // protected methods
    //=======================================================================================
    /* NOTHING */

private:
    //=======================================================================================
    // private variables.
    //=======================================================================================
    ID3D11Texture2D*            m_pTexture;     //!< eNX`ł.
    ID3D11ShaderResourceView*   m_pSRV;         //!< VF[_\[Xr[ł.
    ID3D11DepthStencilView*     m_pDSV;         //!< [xXeVr[ł.

    //=======================================================================================
    // private methods.
    //=======================================================================================
    DepthStencilBuffer( const DepthStencilBuffer& );    // ANZX֎~.
    void operator =   ( const DepthStencilBuffer& );    // ANZX֎~.
};

} // namespace asdx


#endif//__ASDX_DEPTH_BUFFER_H__