//------------------------------------------------------------------------------------------
// File : DemoApp.h
// Desc : Demo Application Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

#ifndef __DEMO_APP_H__
#define __DEMO_APP_H__

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include <Windows.h>
#include <d3d11.h>
#include <d3dcompiler.h>
#include <DirectXMath.h>
#include <vector>
#include <string>
#include "SceneNode.h"


////////////////////////////////////////////////////////////////////////////////////////////
// DemoApp class
////////////////////////////////////////////////////////////////////////////////////////////
class DemoApp
{
    //======================================================================================
    // list of friend classes and methods.
    //======================================================================================
    /* NOTHING */

private:
    //======================================================================================
    // private variables
    //======================================================================================
    /* NOTHING */

    //======================================================================================
    // private methods
    //======================================================================================
    /* NOTHING */

protected:
    //======================================================================================
    // protected variables
    //======================================================================================
    static const UINT           SWAPCHAIN_BUFFER_COUNT      = 2;
    static const DXGI_FORMAT    SWAPCHAIN_BUFFER_FORMAT     = DXGI_FORMAT_R8G8B8A8_UNORM;
    static const DXGI_FORMAT    DEPTHSTENCIL_TEXTURE_FORMAT = DXGI_FORMAT_R24G8_TYPELESS;
    static const DXGI_FORMAT    DEPTHSTENCIL_VIEW_FORMAT    = DXGI_FORMAT_D24_UNORM_S8_UINT;
    static const DXGI_FORMAT    DEPTHSTENCIL_RESOURCE_FORMAT= DXGI_FORMAT_R24_UNORM_X8_TYPELESS;

    static DemoApp*             s_pThis;                //!< g̃|C^.
    HINSTANCE                   m_hInst;                //!< CX^Xnhł.
    HWND                        m_hWnd;                 //!< EBhEnhł.
    D3D_DRIVER_TYPE             m_DriverType;           //!< hCo[^Cvł.
    D3D_FEATURE_LEVEL           m_FeatureLevel;         //!< @\xł.
    UINT                        m_MultiSampleCount;     //!< }`TṽJEgł.
    UINT                        m_MultiSampleQuality;   //!< }`Tv̕ił.
    UINT                        m_MultiSampleMaxQuality;//!< }`Tv̍őilł.
    UINT                        m_SwapChainCount;       //!< Xbv`FC̃JEgł.
    DXGI_FORMAT                 m_SwapChainFormat;      //!< Xbv`FC̃tH[}bgł.
    DXGI_FORMAT                 m_DepthStencilFormat;   //!< [xXeṼtH[}bgł.
    ID3D11Device*               m_pDevice;              //!< foCXł.
    ID3D11DeviceContext*        m_pDeviceContext;       //!< foCXReLXgł.
    IDXGISwapChain*             m_pSwapChain;           //!< Xbv`FCł.
    ID3D11RenderTargetView*     m_pRTV;                 //!< _[^[Qbgr[ł.
    ID3D11DepthStencilView*     m_pDSV;                 //!< [xXeVr[ł.
    ID3D11Texture2D*            m_pRTT;                 //!< _[^[QbgeNX`ł.
    ID3D11Texture2D*            m_pDST;                 //!< [xXeVeNX`ł.
    ID3D11ShaderResourceView*   m_pRTSRV;               //!< _[^[Qbg̃VF[_\[Xr[ł.
    ID3D11ShaderResourceView*   m_pDSSRV;               //!< [xXeṼVF[_\[Xr[ł.
    SceneNode*                  m_pNode;                //!< V[̃[gm[hł.
    FLOAT                       m_ClearColor[4];        //!< NAJ[.
    UINT                        m_Width;                //!< EBhE.
    UINT                        m_Height;               //!< EBhEc.
    FLOAT                       m_AspectRatio;          //!< AXyNg.
    std::string                 m_Title;                //!< ^Cg.

    //======================================================================================
    // protected methods
    //======================================================================================

    //--------------------------------------------------------------------------------------
    //! @brief      EBhȄs܂.
    //--------------------------------------------------------------------------------------
    bool    InitWnd();

    //--------------------------------------------------------------------------------------
    //! @brief      EBhȄIs܂.
    //--------------------------------------------------------------------------------------
    void    TermWnd();

    //--------------------------------------------------------------------------------------
    //! @brief      D3D11̏s܂.
    //--------------------------------------------------------------------------------------
    bool    InitD3D11();

    //--------------------------------------------------------------------------------------
    //! @brief      D3D11̏Is܂.
    //--------------------------------------------------------------------------------------
    void    TermD3D11();

    //--------------------------------------------------------------------------------------
    //! @brief      AvŗL̏s܂.
    //--------------------------------------------------------------------------------------
    bool    InitApp();

    //--------------------------------------------------------------------------------------
    //! @brief      AvŗL̏Is܂.
    //--------------------------------------------------------------------------------------
    void    TermApp();

    //--------------------------------------------------------------------------------------
    //! @brief      C[vł.
    //--------------------------------------------------------------------------------------
    int     MainLoop();

    //--------------------------------------------------------------------------------------
    //! @brief      ɌĂ΂鏈ł.
    //--------------------------------------------------------------------------------------
    bool    OnInit();

    //--------------------------------------------------------------------------------------
    //! @brief      `掞ɌĂ΂鏈ł.
    //--------------------------------------------------------------------------------------
    void    OnRender();

    //--------------------------------------------------------------------------------------
    //! @brief      IɌĂ΂鏈ł.
    //--------------------------------------------------------------------------------------
    void    OnTerm();

    //--------------------------------------------------------------------------------------
    //! @brief      TCYɌĂ΂鏈ł.
    //--------------------------------------------------------------------------------------
    void    OnResize( const UINT w, const UINT h );

    //--------------------------------------------------------------------------------------
    //! @brief      ftHg̃_[^[Qbg𐶐܂.
    //--------------------------------------------------------------------------------------
    bool    CreateDefaultRenderTarget();

    //--------------------------------------------------------------------------------------
    //! @brief      ftHg̐[xXeVobt@𐶐܂.
    //--------------------------------------------------------------------------------------
    bool    CreateDefaultDepthStencil();

    //--------------------------------------------------------------------------------------
    //! @brief      ftHg̃_[^[Qbg܂.
    //--------------------------------------------------------------------------------------
    void    ReleaseDefaultRenderTarget();

    //--------------------------------------------------------------------------------------
    //! @brief      ftHg̐[xXeVobt@܂.
    //--------------------------------------------------------------------------------------
    void    ReleaseDefaultDepthStencil();

    //--------------------------------------------------------------------------------------
    //! @brief      EBhEvV[Wł.
    //--------------------------------------------------------------------------------------
    static LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp );

public:
    //======================================================================================
    // public variables
    //======================================================================================
    struct Config
    {
        UINT        swapChainCount;
        DXGI_FORMAT swapChainFormat;
        DXGI_FORMAT depthStencilFormat;
        UINT        multiSampleCount;
        UINT        multiSampleQuality;
        UINT        width;
        UINT        height;
        LPSTR       title;
        FLOAT       clearColorR;
        FLOAT       clearColorG;
        FLOAT       clearColorB;
        FLOAT       clearColorA;

        Config()
        : swapChainCount    ( 2 )
        , swapChainFormat   ( DXGI_FORMAT_R8G8B8A8_UNORM )
        , depthStencilFormat( DXGI_FORMAT_D24_UNORM_S8_UINT )
        , multiSampleCount  ( 1 )
        , multiSampleQuality( 0 )
        , width             ( 960 )
        , height            ( 540 )
        , title             ( "DemoApp" )
        , clearColorR       ( 0.392f )
        , clearColorG       ( 0.584f )
        , clearColorB       ( 0.929f )
        , clearColorA       ( 1.0f )
        { /* DO_NOTHING */ }
    };

    //======================================================================================
    // public methods
    //======================================================================================

    //--------------------------------------------------------------------------------------
    //! @brief      tRXgN^ł.
    //--------------------------------------------------------------------------------------
    DemoApp( const Config& config );

    //--------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //--------------------------------------------------------------------------------------
    virtual ~DemoApp();

    //--------------------------------------------------------------------------------------
    //! @brief      AvP[Vs܂.
    //--------------------------------------------------------------------------------------
    int     Run();

    //--------------------------------------------------------------------------------------
    //! @brief      m[hݒ肵܂.
    //--------------------------------------------------------------------------------------
    void    SetNode( SceneNode* pNode );

    //--------------------------------------------------------------------------------------
    //! @brief      m[h擾܂.
    //--------------------------------------------------------------------------------------
    SceneNode* GetNode() const;

    //--------------------------------------------------------------------------------------
    //! @brief      foCXC^tF[X擾܂.
    //--------------------------------------------------------------------------------------
    ID3D11Device* GetDevice() const;

    //--------------------------------------------------------------------------------------
    //! @brief      foCXReLXgC^tF[X擾܂.
    //--------------------------------------------------------------------------------------
    ID3D11DeviceContext* GetDeviceContext() const;

    //--------------------------------------------------------------------------------------
    //! @brief      _[^[Qbgr[擾܂.
    //--------------------------------------------------------------------------------------
    ID3D11RenderTargetView* GetRenderTargetView() const;

    //--------------------------------------------------------------------------------------
    //! @brief      [xXeVr[擾܂.
    //--------------------------------------------------------------------------------------
    ID3D11DepthStencilView* GetDepthStencilView() const;

    //--------------------------------------------------------------------------------------
    //! @brief      [xXeṼVF[_\[Xr[擾܂.
    //--------------------------------------------------------------------------------------
    ID3D11ShaderResourceView* GetDepthStencilShaderResourceView() const;

    //--------------------------------------------------------------------------------------
    //! @brief      Xbv`FC擾܂.
    //--------------------------------------------------------------------------------------
    IDXGISwapChain* GetSwapChain() const;

    //--------------------------------------------------------------------------------------
    //! @brief      EBhẺ擾܂.
    //--------------------------------------------------------------------------------------
    UINT    GetWidth() const;

    //--------------------------------------------------------------------------------------
    //! @brief      EBhȄc擾܂.
    //--------------------------------------------------------------------------------------
    UINT    GetHeight() const;

    //--------------------------------------------------------------------------------------
    //! @brief      AXyNg擾܂.
    //--------------------------------------------------------------------------------------
    FLOAT   GetAspectRatio() const;

    //--------------------------------------------------------------------------------------
    //! @brief      ANeBuȃAvP[V擾܂.
    //--------------------------------------------------------------------------------------
    static DemoApp* GetActive();
};


#endif//__DEMO_APP_H__
